<?php
class WelcomeModel extends CI_Model {
    public function get_data_in_alp_order($table){
        $info=array();
        $this->db->select('*');
        $this->db->order_by('student_name','ASC');
        $this->db->from($table);
        $info=$this->db->get()->result_array();
        return $info;        
    }
    
    public function get_active_data_in_alp_order($table){
        $info=array();
        $this->db->select('*');
        $this->db->where('status',1);
        $this->db->order_by('student_name','ASC');
        $this->db->from($table);
        $info=$this->db->get()->result_array();
        return $info;        
    }
    
    
    public function get_active_data_in_alp_order_new($course_id,$acedemic_session){
        $sql="SELECT stud.*,scd.section as current_section,scd.class as current_class FROM student as stud LEFT JOIN student_courses_data as scd on stud.id=scd.sid WHERE stud.status = 1 AND scd.acedemic_session='$acedemic_session' AND scd.course_id='$course_id' ORDER BY scd.section,stud.student_name ASC ";
        
        $query=$this->db->query($sql);        
        return $query->result_array();
    }
    
    
    public function get_active_data_in_alp_order_without_sch_no($table){
        $info=array();
        $this->db->select('*');
        $this->db->where('status',1);
        $this->db->order_by('student_name','ASC');
        $this->db->from($table);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function insert_data1($data_array1,$table1){
        $this->db->insert($table1,$data_array1);
        return $this->db->insert_id();    
    }

    public function insert_data($data_array,$table){
        $this->db->insert($table,$data_array);
        return $this->db->insert_id();    
    }

    public function update_item_data($data_array_update,$id,$table){
        $this->db->where("id",$id);
        $this->db->update($table,$data_array_update);
        return $this->db->affected_rows();
    }

    public function get_data($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $info=$this->db->get()->result_array();
        return $info;
    }

    public function check_user_exist($email,$password) {
        $table='users';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('userEmail',$email);
        $this->db->where('password',$password);
        // $this->db->order_by('id',"DESC");
        $info=$this->db->get()->result_array();
        return $info; 
    }


    public function get_item_data($id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('id',$id);
        $info=$this->db->get()->result_array();
        return $info; 
    }

    public function check_course_exist($course,$subject_stream){
        $table='courses';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('course',$course);
        $this->db->where('subject_stream',$subject_stream);
        $info=$this->db->get()->result_array();
        return $info;  
    }
    public function get_students_ac_session($acedemic_session){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        // $this->db->where('sid',$sid);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info; 
    } 

    public function get_student_in_acedemic_session($sid,$acedemic_session){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }

    public function get_students_ac_session_by_class($acedemic_session,$my_class,$class_teacher_section){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('class',$my_class);
        $this->db->where('section',$class_teacher_section);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->order_by('roll_no','ASC');
        $info=$this->db->get()->result_array();
        return $info; 
    }
    
    public function get_students_ac_session_by_course_and_class($course_id,$acedemic_session,$my_class,$class_teacher_section){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('class',$my_class);
        $this->db->where('section',$class_teacher_section);
        $this->db->where('course_id',$course_id);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->order_by('roll_no','ASC');
        $info=$this->db->get()->result_array();
        return $info; 
    }


    public function get_class_students_by_ac_session($acedemic_session,$my_class){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('class',$my_class);
        // $this->db->where('section',$class_teacher_section);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info; 
    }

    public function class_teacher_info($acedemic_session,$tid){
        $table='school_classes_structure';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('class_teacher',$tid);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info; 
    }


    public function get_class_teachers_by_session($acedemic_session){
        $table='school_classes_structure';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }

    public function get_admission_refrence_data($refrence,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('enquiry_id',$refrence);
        $info=$this->db->get()->result_array();
        return $info;
    }

    public function get_staff_readreceipt($user_id,$circular_id){
        $table='read_receipt';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('circular_id',$circular_id);
        $this->db->where('staff_id',$user_id);
        $info=$this->db->get()->result_array();
        return $info;
    }

    public function get_data_in_status_order($table){
        // $table='users';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('status',0);
        // $this->db->where('password',$password);
        $this->db->order_by('user_status',"DESC");
        $info=$this->db->get()->result_array();
        return $info;
    }

    public function teachers_class_info($tid,$acedemic_session){
        $table='school_classes_structure';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('class_teacher',$tid);
        $info=$this->db->get()->result_array();
        return $info;
    }

    public function get_course_students_by_ac_session($acedemic_session,$my_class){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('class',$my_class);
        // $this->db->where('section',$class_teacher_section);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_course_students_by_ac_session_by_course_id($acedemic_session,$course_id){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('course_id',$course_id);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_course_info($course_id){
        $table='courses';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('id',$course_id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function update_status_in_student_courses_data($sid,$data_array_update){
        $table='student_courses_data';
        $this->db->where("sid",$sid);
        $this->db->update($table,$data_array_update);    
        return $this->db->affected_rows(); 
    }
    
    public function get_course_wise_student_in_alpha_order($course_id,$acedemic_session){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('course_id',$course_id);
        $this->db->where('acedemic_session',$acedemic_session);
        // $this->db->order_by('student_name',"ASC");
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_course_wise_student_in_alpha_order_new($course_id,$acedemic_session){
        $sql="SELECT student.*,scd.new_admission,scd.sid FROM student LEFT JOIN student_courses_data as scd on scd.sid = student.id WHERE scd.course_id='$course_id' AND scd.acedemic_session='$acedemic_session' ORDER BY student.student_name ASC";
        $query=$this->db->query($sql);        
        return $query->result_array();
    }
    
    public function get_class_teacher_for_class_section($class,$section,$acedemic_session){
        $table='school_classes_structure';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('class',$class);
        $this->db->where('section',$section);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_student_exam_result($sid,$exam_id,$exam_result_table){
        $info=array();
        $this->db->select('*');
        $this->db->from($exam_result_table);
        $this->db->where('sid',$sid);
        $this->db->where('exam_id',$exam_id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function class_section_students($class,$section,$acedemic_session){
        $sql="SELECT student.* FROM student LEFT JOIN student_courses_data as scd on scd.sid = student.id WHERE scd.class='$class' AND scd.section='$section' AND scd.acedemic_session='$acedemic_session' ORDER BY student.student_name ASC";
        $query=$this->db->query($sql);        
        return $query->result_array();
    }
    
    public function get_students_ac_session_combined($acedemic_session){
        // $table='student_courses_data';
        // $info=array();
        // $this->db->select('*');
        // $this->db->from($table);
        // // $this->db->where('sid',$sid);
        // $this->db->where('acedemic_session',$acedemic_session);
        // $info=$this->db->get()->result_array();
        // return $info; 
        

        $sql="SELECT student.*,scd.class as ac_class,scd.section as ac_section FROM student LEFT JOIN student_courses_data as scd on scd.sid = student.id WHERE scd.acedemic_session='$acedemic_session' ORDER BY student.student_name ASC";
        $query=$this->db->query($sql);        
        return $query->result_array();
    }
    
    public function get_student_data($sid,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_staff_attendance_count($date){
        $sql="SELECT staff_attendence.id FROM staff_attendence LEFT JOIN school_staff ON school_staff.id=staff_attendence.userId WHERE staff_attendence.markInDate='$date' AND school_staff.status=0 AND school_staff.user_status=1";
        $query=$this->db->query($sql);        
        return count($query->result_array());
        
        // $this->db->select('*');
        // $this->db->from('staff_attendence');
        // $this->db->where('markInDate',$date);
        // return $this->db->get()->num_rows(); 
    }
    
    public function get_staff_count(){
        $sql="SELECT * FROM school_staff WHERE school_staff.status=0 AND school_staff.user_status=1";
        $query=$this->db->query($sql);        
        return count($query->result_array());
    }
    
    public function get_rte_students_count($acedemic_session){
        // $this->db->select('*');
        // $this->db->from('rte_students');
        // $this->db->where('acedemic_session',$acedemic_session);
        // $this->db->where('status','active');
        // return $this->db->get()->num_rows(); 
        
        $sql="SELECT rte_students.* FROM rte_students LEFT JOIN student ON rte_students.sid=student.id WHERE rte_students.status='active' AND rte_students.acedemic_session='$acedemic_session'";
        $query=$this->db->query($sql);  
        return count($query->result_array());
    }
    
    public function get_acedemic_session_exams($acedemic_session,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('status','active');
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
} 