<?php
class LedgerModel extends CI_MODEL{
    
    public function insert_data($data_array,$table){
        $this->db->insert($table,$data_array);
        return $this->db->insert_id();
    }
    
    public function check_opening_balance_exist($sid,$acedemic_session,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('fee_type','opening_balance');
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    
    public function get_data_asc($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('id','ASC');
        $info=$this->db->get()->result_array();
        return $info;
    }

    public function get_item_data($id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('id',$id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_opening_balance_fee($sid,$acedemic_session){
        $table='opening_balance_fee';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function fee_invoice_exist($sid,$fee_type,$inv_no,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $this->db->where('fee_type',$fee_type);
        $this->db->where('inv_no',$inv_no);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_ledger_data($sid,$acedemic_session,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('date','ASC');
        $this->db->where('sid',$sid);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function student_course_info($sid,$acedemic_session){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function fee_structure($course_id,$ac_session){
        $table='fee_structure';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('course_id',$course_id);
        $this->db->where('acedemic_session',$ac_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function check_monthly_fee_debit_info($month_name,$sid,$acedemic_session,$monthly_fee_type,$dr_date,$ledger_table){
        $info=array();
        $this->db->select('*');
        $this->db->from($ledger_table);
        $this->db->where('month_name',$month_name);
        $this->db->where('sid',$sid);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('fee_type',$monthly_fee_type);
        $this->db->where('date',$dr_date);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_fee_invoices($sid,$acedemic_session){
        $table='student_fee';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_invoice_info($fee_no){
        $table='student_fee';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('fee_no',$fee_no);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_active_students($acedemic_session){
        $sql="SELECT scd.sid,scd.new_admission,scd.course_id FROM student_courses_data as scd LEFT JOIN student ON scd.sid=student.id WHERE student.status = 1 AND scd.acedemic_session='$acedemic_session'";
        $query=$this->db->query($sql);        
        return $query->result_array();
    }
    
    public function get_active_data($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('status',1);
        $info=$this->db->get()->result_array();
        return $info;    
    }
    
    
    public function monthly_fee_structure($course_id,$ac_session){
        $table='fee_structure';
        // $info=array();
        // $this->db->select('*');
        // $this->db->from($table);
        // $this->db->where('course_id',$course_id);
        // $this->db->where('acedemic_session',$ac_session);
        // $info=$this->db->get()->result_array();
        // return $info;
        
        $sql="SELECT fee_structure.* FROM fee_structure LEFT JOIN fee_heads ON fee_heads.id=fee_structure.fee_head WHERE fee_structure.course_id='$course_id' AND fee_structure.acedemic_session='$ac_session' AND fee_heads.fee_type = 'monthly' ";
        $query=$this->db->query($sql);        
        return $query->result_array();
    }
}
?>