<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Transport extends CI_Controller {

    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('TransportModel');
        $this->load->model('NewFeeModel');
        $this->load->model('WelcomeModel');
        $this->load->helper('date');
        $this->load->database();    
        $this->load->library('form_validation');
        $this->load->library('session');
        $this->load->library('Pdf');
    }
    
    public function index(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/transport/dashboard');
        $this->load->view('erp/footer');
    }
    
    public function add_new_vehicle(){
        $data['success']=''; $data['error']='';
        if(isset($_POST['edit'])){
            $data['data'] = $_POST['edit'];
        }
        
        if(isset($_POST['add_new_vehicle'])){
            $id=$this->input->post('id');
            $vehicle_number=$this->input->post('vehicle_number');
            $vehicle_model=$this->input->post('vehicle_model');
            $rcnumber=$this->input->post('rcnumber');
            $no_of_seats=$this->input->post('no_of_seats');
            $vehicle_componey=$this->input->post('vehicle_componey');
            $vehicle_driver=$this->input->post('vehicle_driver');
            $assistance_driver=$this->input->post('assistance_driver');
            
            $vehicle_owner_name=$this->input->post('vehicle_owner_name');
            $vehicle_owner_contact_number=$this->input->post('vehicle_owner_contact_number');
            $vehicle_owner_address=$this->input->post('vehicle_owner_address');
            
            $cat=date('Y-m-d H:i:s');
            $tid=$this->session->userdata('tid');
            
            $vehicles_table='transport_vehicle';
            $check_item_exist=$this->TransportModel->get_item_data($id,$vehicles_table);
                if($check_item_exist){
                    $update_data_array=array("vehicle_number"=>$vehicle_number,"vehicle_model"=>$vehicle_model,"vehicle_rc_number"=>$rcnumber,"number_of_seats"=>$no_of_seats,"vehicle_componey"=>$vehicle_componey,"driver_on_duty"=>$vehicle_driver,"assistance_driver"=>$assistance_driver,"vehicle_owner_name"=>$vehicle_owner_name,"vehicle_owner_contact_number"=>$vehicle_owner_contact_number,"vehicle_owner_address"=>$vehicle_owner_address,"uat"=>$cat,"upd_by"=>$tid);
                    $update_vehicle_info=$this->TransportModel->update_item_data($id,$update_data_array,$vehicles_table);
                    if($update_vehicle_info){
                        $data['success']='Updated Successfully';
                    }else{$data['error']='Error in updating vehicle info';}
                }else{
                    $data_array=array("vehicle_number"=>$vehicle_number,"vehicle_model"=>$vehicle_model,"vehicle_rc_number"=>$rcnumber,"number_of_seats"=>$no_of_seats,"vehicle_componey"=>$vehicle_componey,"driver_on_duty"=>$vehicle_driver,"assistance_driver"=>$assistance_driver,"vehicle_owner_name"=>$vehicle_owner_name,"vehicle_owner_contact_number"=>$vehicle_owner_contact_number,"vehicle_owner_address"=>$vehicle_owner_address,"status"=>1,"cat"=>$cat,"cat_by"=>$tid);
                    $check_vehicle_exist=$this->TransportModel->check_vehicle_exist($vehicle_number,$vehicle_model,$rcnumber,$vehicle_componey,$no_of_seats,$vehicles_table);
                    if($check_vehicle_exist){
                        $data['error']='This vehicle is already exist !';
                    }else{
                        $add_new_vehicles=$this->TransportModel->insert_data($data_array,$vehicles_table);
                        if($add_new_vehicle){
                            $data['success']='Vehicle Added Successfully.';
                        }
                    }
                }
        }        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/transport/add-new-vehicle',$data);
        $this->load->view('erp/footer');
    }
    
    public function add_new_vehicle_driver(){
        $data['success']=''; $data['error']='';
        
        if(isset($_POST['edit'])){
            $data['data'] = $_POST['edit'];
        }
        
        if(isset($_POST['add_new_driver'])){
            $driver_name=$this->input->post('driver_name');
            $driver_father_name=$this->input->post('driver_father_name');
            $dob=$this->input->post('dob');
            $driver_contact_no=$this->input->post('driver_contact_no');
            $address=$this->input->post('address');
            $experience=$this->input->post('experience');
            $driver_license_no=$this->input->post('driver_license_no');
            $dl_renewal_date=$this->input->post('dl_renewal_date');
            $driver_table='vehicle_driver';
            $cat=date('Y-m-d H:i:s');
            $tid=$this->session->userdata('tid');
            $staff_type=$this->input->post('staff_type');
            
            
            $profile_pic='';
            $driving_license_copy='';
            $id=$this->input->post('id');
            $drivers_table='vehicle_driver';
            
            $profile_pic_old='';
            $driving_license_copy='';
            
            
            $check_driver_data=$this->TransportModel->get_item_data($id,$drivers_table);
            if($check_driver_data){
                
                if($_FILES['driver_profile_picture']['name']){
                    $profile_pic = preg_replace("/[^a-zA-Z0-9.-]+/", "", $_FILES['driver_profile_picture']['name']);
                    $profile_pic = mt_rand(999999,9999999).'-'.$profile_pic;
                    move_uploaded_file($_FILES['driver_profile_picture']['tmp_name'], $_SERVER['DOCUMENT_ROOT']."/assets/drivers/profiles/".$profile_pic);
                    $profile_pic = ''.base_url().'assets/drivers/profiles/'.$profile_pic;
                }
            
                if($_FILES['driving_license_copy']['name']){
                    $driving_license_copy = preg_replace("/[^a-zA-Z0-9.-]+/", "", $_FILES['driving_license_copy']['name']);
                    $driving_license_copy = mt_rand(999999,9999999).'-'.$driving_license_copy;
                    move_uploaded_file($_FILES['driving_license_copy']['tmp_name'], $_SERVER['DOCUMENT_ROOT']."/assets/drivers/dl/".$driving_license_copy);
                    $driving_license_copy = ''.base_url().'assets/drivers/dl/'.$driving_license_copy;
                }        
                
                foreach($check_driver_data as $driver_data){
                    $profile_pic_old=$driver_data['photo'];
                    $driving_license_copy=$driver_data['driving_license_copy'];
                }
                
                if($profile_pic =='' && $profile_pic_old !=''){
                    $profile_pic=$profile_pic_old;
                }
                if($driving_license_copy =='' && $driving_license_copy !=''){
                    $driving_license_copy=$driving_license_copy;
                }
                $data_array_update=array("driver_name"=>$driver_name,"driver_father_name"=>$driver_father_name,"dob"=>$dob,"driver_contact_no"=>$driver_contact_no,"address"=>$address,"experience"=>$experience,"driver_license_no"=>$driver_license_no,"dl_renewal_date"=>$dl_renewal_date,"uat"=>$cat,"uby"=>$tid,"driving_license_copy"=>$driving_license_copy,"photo"=>$profile_pic,"staff_type"=>$staff_type);
                $update_profile_info=$this->TransportModel->update_item_data($id,$data_array_update,$drivers_table);
                if($update_profile_info){
                    $data['success']="Driver's profile updated successfully !";
                }else{
                    $data['error']='Error in updating profile data';
                }
                
            }else{
                
            $check_driver_already_exist=$this->TransportModel->check_vehicle_driver_exist($driver_contact_no,$driver_name,$driver_table);
            if($check_driver_already_exist){
                $data['error']='Already Exist';
            }else{
                
            if($_FILES['driver_profile_picture']['name']){
                $profile_pic = preg_replace("/[^a-zA-Z0-9.-]+/", "", $_FILES['driver_profile_picture']['name']);
                $profile_pic = mt_rand(999999,9999999).'-'.$profile_pic;
                move_uploaded_file($_FILES['driver_profile_picture']['tmp_name'], $_SERVER['DOCUMENT_ROOT']."/assets/drivers/profiles/".$profile_pic);
                $profile_pic = ''.base_url().'assets/drivers/profiles/'.$profile_pic;
            }
            
            if($_FILES['driving_license_copy']['name']){
                $driving_license_copy = preg_replace("/[^a-zA-Z0-9.-]+/", "", $_FILES['driving_license_copy']['name']);
                $driving_license_copy = mt_rand(999999,9999999).'-'.$driving_license_copy;
                move_uploaded_file($_FILES['driving_license_copy']['tmp_name'], $_SERVER['DOCUMENT_ROOT']."/assets/drivers/dl/".$driving_license_copy);
                $driving_license_copy = ''.base_url().'assets/drivers/dl/'.$driving_license_copy;
            }
                
                $data_array=array("driver_name"=>$driver_name,"driver_father_name"=>$driver_father_name,"dob"=>$dob,"driver_contact_no"=>$driver_contact_no,"address"=>$address,"experience"=>$experience,"driver_license_no"=>$driver_license_no,"dl_renewal_date"=>$dl_renewal_date,"cat"=>$cat,"cby"=>$tid,"driving_license_copy"=>$driving_license_copy,"photo"=>$profile_pic,"staff_type"=>$staff_type,"status"=>1);
                $add_new_driver=$this->TransportModel->insert_data($data_array,$driver_table);
                if($add_new_driver){$data['success']='Added Successfully';}else{$data['error']="Error in adding new vehicle !";}
            }
            
            }
        }
        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/transport/add-vehicle-driver',$data);
        $this->load->view('erp/footer');
    }
    
    public function vehicles(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/transport/vehicles');
        $this->load->view('erp/footer');
    }
    
    public function drivers(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/transport/list-vehicle-drivers');
        $this->load->view('erp/footer');
    }
    
    public function delete_item_data(){
        $item_id=$_POST['item_id'];
        $table=$_POST['item_block'];
        $data_array_update=array("is_deleted"=>1,"status"=>3);
        $delete_item_data=$this->TransportModel->update_item_data($item_id,$data_array_update,$table);
        if($delete_item_data){
            echo "Item Deleted Successfully";
        }
        
    }
    
    public function students(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/transport/list-students');
        $this->load->view('erp/footer');
    }
    
    public function list_student(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/transport/all-students');
        $this->load->view('erp/footer');        
    }
    
    public function add_new_student(){
        
    }
    
    public function routes(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/transport/transport-routes');
        $this->load->view('erp/footer');        
    }
    
    public function add_new_route(){
        $data['success']=''; $data['error']='';
        
        if(isset($_POST['edit'])){
            $data['data'] = $_POST['edit'];
        }
        
        if(isset($_POST['add_new_route'])){
            $id=$this->input->post('id');
            $route_title=$this->input->post('route_title');
            $route_start_point=$this->input->post('route_start_point');
            $route_end_point=$this->input->post('route_end_point');
            $route_fare=$this->input->post('route_fare');
            $routes_table='transport_routes';
            $tid=$this->session->userdata('tid');
            $cat=date('Y-m-d H:i:s');
            
            $check_route_exist=$this->TransportModel->get_item_data($id,$routes_table);
            if($check_route_exist){
                $data_array_update=array("route_title"=>$route_title,"route_start"=>$route_start_point,"route_end"=>$route_end_point,"route_fare"=>$route_fare,"uat"=>$cat,"upd_by"=>$tid);
                $update_route_info=$this->TransportModel->update_item_data($id,$data_array_update,$routes_table);
                if($update_route_info){
                    $data['success']='Updated Successfully';
                }
                
            }else{
                $data_array=array("route_title"=>$route_title,"route_start"=>$route_start_point,"route_end"=>$route_end_point,"route_fare"=>$route_fare,"cat"=>$cat,"cat_by"=>$tid,"status"=>1);
                $check_route_exist=$this->TransportModel->check_route_exist($route_title,$route_start_point,$route_end_point,$routes_table);
                if($check_route_exist){
                    $data['error']='Route Already exist';
                }else{
                    $add_new_route=$this->TransportModel->insert_data($data_array,$routes_table);
                    if($add_new_route){
                        $data['success']='Route added successfully';
                    }
                }                
            }
            
            

            
            
        }
        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/transport/add-new-route',$data);
        $this->load->view('erp/footer');        
    }
    
    public function add_student(){
        $data['success']=''; $data['error']='';
        if(isset($_POST['add_new_student'])){
            $sid=$this->input->post('sid');
            $route_id=$this->input->post('route_id');
            $route_fare=$this->input->post('route_fare');
            $extra_route_fare=$this->input->post('extra_route_fare');
            $vehicle_id=$this->input->post('vehicle_id');
            $acedemic_session=$this->session->userdata('acedemic_session');
            
                        
            $apr_status=0;
            $may_status=0;
            $jun_status=0;
            $jul_status=0;
            $aug_status=0;
            $sep_status=0;
            $oct_status=0;
            $nov_status=0;
            $dec_status=0;
            $jan_status=0;
            $feb_status=0;
            $mar_status=0;

            $apr_status=$apr_status + $this->input->post('apr_status');
            $may_status=$may_status + $this->input->post('may_status');
            $jun_status=$jun_status + $this->input->post('jun_status');
            $jul_status=$jul_status + $this->input->post('jul_status');

            $aug_status=$aug_status + $this->input->post('aug_status');
            $sep_status=$sep_status + $this->input->post('sep_status');
            $oct_status=$oct_status + $this->input->post('oct_status');
            $nov_status=$nov_status + $this->input->post('nov_status');
            
            $dec_status=$dec_status + $this->input->post('dec_status');
            $jan_status=$jan_status + $this->input->post('jan_status');
            $feb_status=$feb_status + $this->input->post('feb_status');
            $mar_status=$mar_status + $this->input->post('mar_status');
            
            
            $table='transport_student_report';
            
            $data_array=array("status"=>1,"sid"=>$sid,"route_no"=>$route_id,"fare"=>$route_fare,"extra_fare"=>$extra_route_fare,"vehicle_no"=>$vehicle_id,"acedemic_session"=>$acedemic_session,"april"=>$apr_status,"may"=>$may_status,"june"=>$jun_status,"july"=>$jul_status,"august"=>$aug_status,"september"=>$sep_status,"october"=>$oct_status,"november"=>$nov_status,"december"=>$dec_status,"january"=>$jan_status,"february"=>$feb_status,"march"=>$mar_status);
            $data_array_update=array("status"=>1,"route_no"=>$route_id,"fare"=>$route_fare,"extra_fare"=>$extra_route_fare,"vehicle_no"=>$vehicle_id,"april"=>$apr_status,"may"=>$may_status,"june"=>$jun_status,"july"=>$jul_status,"august"=>$aug_status,"september"=>$sep_status,"october"=>$oct_status,"november"=>$nov_status,"december"=>$dec_status,"january"=>$jan_status,"february"=>$feb_status,"march"=>$mar_status);            
            
            $check_student_exist_in_session=$this->TransportModel->get_student_info_for_ac_sesssion($sid,$acedemic_session);
            if($check_student_exist_in_session){
                // $data['error']="Already Added";
                $update_transport_info=$this->TransportModel->update_student_info($sid,$acedemic_session,$data_array_update);    
                if($update_transport_info){
                    $data['success']='Updated Successfully';
                }else{
                    $data['error']='Error in updating student info';
                }
                
            }else{
                $add_student=$this->TransportModel->insert_data($data_array,$table);
                if($add_student){
                    $data['success']='Added Successfully';
                }else{
                    $data['error']='Error in adding student';
                }
            }
        }

        
        
        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/transport/add-student',$data);
        $this->load->view('erp/footer');        
    }
    
    public function get_route_fee(){
        $route_id=$_POST['route_id'];
        $route_table='transport_routes';
        $get_route_info=$this->TransportModel->get_item_data($route_id,$route_table);
        if($get_route_info){
            foreach($get_route_info as $route_info){
                echo $route_fare=$route_info['route_fare'];
            }
        }
    }
    
    public function fee(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/transport/fee');
        $this->load->view('erp/transport/pay-fee');
        
        $this->load->view('erp/footer');
    }
    
    public function pay_fee(){
        $cat=date("Y-m-d H:i:s");
        $tid=$this->session->userdata("tid");
        $sid=$_POST['sid'];
        $acedemic_session=$_POST['acedemic_session'];
        $all_fee_months=$_POST['all_fee_months'];
        $est_amount=$_POST['est_amount'];
        $prev_extra_amount=$_POST['prev_extra_amount'];
        $prev_bal_amount=$_POST['prev_bal_amount'];
        $discount_amount=$_POST['discount_amount'];
        $received_fee=$_POST['received_fee'];
        $fee_date=$_POST['fee_date'];
        $bal_fee=$_POST['bal_fee'];
        $extra_fee=$_POST['extra_fee'];
        $status_4=$_POST['status_4'];
        $status_5=$_POST['status_5'];
        $status_6=$_POST['status_6'];
        $status_7=$_POST['status_7'];
        $status_8=$_POST['status_8'];
        $status_9=$_POST['status_9'];
        $status_10=$_POST['status_10'];
        $status_11=$_POST['status_11'];
        $status_12=$_POST['status_12'];
        $status_1=$_POST['status_1'];
        $status_2=$_POST['status_2'];
        $status_3=$_POST['status_3'];
        $fee_mode=$_POST['fee_mode'];
        $fee_note=$_POST['fee_note'];
        $transaction_info=$_POST['transaction_info'];
        $route_id=$_POST['route_id'];
        $extra_fee_status=0;
        if($extra_fee >0){
            $extra_fee_status=1;
        }
        
        $bal_fee_status=0;
        if($bal_fee>0){
            $bal_fee_status=1;    
        }
            
        // $sid=$_POST['sid'];
        // $acedemic_session=$_POST['acedemic_session'];
        $prevbalfeeinvoice=0;
        $get_prev_bal_fee_amount=$this->TransportModel->get_prev_bal_fee_amount($sid,$acedemic_session);
        if($get_prev_bal_fee_amount){
           foreach($get_prev_bal_fee_amount as $prev_bal_fee_amount){
               $prevbalfeeinvoice =$prev_bal_fee_amount['id'];
           }
        }
        // echo $prevbalfeeamount;
        
    
    
    
        // $sid=$_POST['sid'];
        // $acedemic_session=$_POST['acedemic_session'];
        $prev_extra_fee_invoice=0;
        $get_prev_extra_fee_amount=$this->TransportModel->get_prev_extra_fee_amount($sid,$acedemic_session);
        if($get_prev_extra_fee_amount){
            foreach($get_prev_extra_fee_amount as $prev_extra_fee_amount){
                $prev_extra_fee_invoice=$prev_extra_fee_amount['id'];
            }
        }
        // echo $prev_extra_fee;
        // $prev_extra_amount
        // $prev_bal_amount
        $table='transport_fee';
        $data_array=array(
            "sid"=>$sid,
            "acedemic_session"=>$acedemic_session,
            "fee_months"=>$all_fee_months,
            "fee_date"=>$fee_date,
            "esatimate_fee"=>$est_amount,
            "extra_amount_used"=>$prev_extra_amount,
            "extra_amount_used_refrence"=>$prev_extra_fee_invoice,
            "prev_bal_added"=>$prev_bal_amount,
            "prev_bal_added_refrence"=>$prevbalfeeinvoice,
            "discount"=>$discount_amount,
            "received_fee"=>$received_fee,
            "balance_fee"=>$bal_fee,
            "balance_fee_status"=>$bal_fee_status,
            "extra_fee"=>$extra_fee,
            "extra_fee_status"=>$extra_fee_status,
            "april"=>$status_4,
            "may"=>$status_5,
            "june"=>$status_6,
            "july"=>$status_7,
            "august"=>$status_8,
            "september"=>$status_9,
            "october"=>$status_10,
            "november"=>$status_11,
            "december"=>$status_12,
            "january"=>$status_1,
            "february"=>$status_2,
            "march"=>$status_3,
            "fee_mode"=>$fee_mode,
            "fee_note"=>$fee_note,
            "transaction_info"=>$transaction_info,
            "route_id"=>$route_id,
            "cat"=>$cat,
            "cat_by"=>$tid,
            "uat"=>$cat,
            "upd_by"=>$tid
        );        
        
        $check_fee_exist=$this->TransportModel->check_fee_data_exist($sid,$acedemic_session,$status_1,$status_2,$status_3,$status_4,$status_5,$status_6,$status_7,$status_8,$status_9,$status_10,$status_11,$status_12);
        if($check_fee_exist){
            echo "Duplicate Invoice";
        }else{
            $add_fee=$this->TransportModel->insert_data($data_array,$table);
            if($add_fee){
                if($prev_extra_fee_invoice !=0){
                    $data_array_update=array("extra_fee_status"=>2);
                    $update_prev_extra_used_status=$this->TransportModel->update_item_data($prev_extra_fee_invoice,$data_array_update,$table);
                    if($update_prev_extra_used_status){
                        echo "Extra Invoice Status Updated Successfully";
                    }
                }
                if($prevbalfeeinvoice !=0){
                    $data_array_update=array("balance_fee_status"=>2);
                    $update_prev_extra_used_status=$this->TransportModel->update_item_data($prevbalfeeinvoice,$data_array_update,$table);
                    if($update_prev_extra_used_status){
                        echo "Balance Invoice Status Updated Successfully";
                    }
                }
                
                echo "Fee Submitted Successfully";
            }
        }
    }
    
    public function edit_fee($id){
        // edit-fee
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        // $this->load->view('erp/transport/fee');
        $this->load->view('erp/transport/edit-fee');
        $this->load->view('erp/footer');
    }
    
    public function get_months(){
        $apr_fee_status=0;
        $may_fee_status=0;
        $jun_fee_status=0;
        $jul_fee_status=0;
        $aug_fee_status=0;
        $sep_fee_status=0;
        $oct_fee_status=0;
        $nov_fee_status=0;
        $dec_fee_status=0;
        $jan_fee_status=0;
        $feb_fee_status=0;
        $mar_fee_status=0;
        
        $apr_status=0;
        $may_status=0;
        $jun_status=0;
        $jul_status=0;
        $aug_status=0;
        $sep_status=0;
        $oct_status=0;
        $nov_status=0;
        $dec_status=0;
        $jan_status=0;
        $feb_status=0;
        $mar_status=0;        
        
        $fee_amount=0;                
        $sid=$_POST['sid'];
        $acedemic_session=$_POST['acedemic_session'];
        
        $get_student_transport_info=$this->TransportModel->get_student_info_for_ac_sesssion($sid,$acedemic_session);
        if($get_student_transport_info){
            foreach($get_student_transport_info as $student_transport_info){
                $fee_amount=$fee_amount + $student_transport_info['fare'] + $student_transport_info['extra_fare'];
                $apr_status=$apr_status + $student_transport_info['april'];
                $may_status=$may_status + $student_transport_info['may'];
                $jun_status=$jun_status + $student_transport_info['june'];
                $jul_status=$jul_status + $student_transport_info['july'];
                $aug_status=$aug_status + $student_transport_info['august'];
                $sep_status=$sep_status + $student_transport_info['september'];
                $oct_status=$oct_status + $student_transport_info['october'];
                $nov_status=$nov_status + $student_transport_info['november'];
                $dec_status=$dec_status + $student_transport_info['december'];
                $jan_status=$jan_status + $student_transport_info['january'];
                $feb_status=$feb_status + $student_transport_info['february'];
                $mar_status=$mar_status + $student_transport_info['march'];
            }
        }
        
        $get_transport_fee=$this->TransportModel->get_transport_fee($sid,$acedemic_session);
        if($get_transport_fee){
            foreach($get_transport_fee as $transport_fee){
                $apr_fee_status=$apr_fee_status + $transport_fee['april'];
                $may_fee_status=$may_fee_status + $transport_fee['may'];
                $jun_fee_status=$jun_fee_status + $transport_fee['june'];
                $jul_fee_status=$jul_fee_status + $transport_fee['july'];
                $aug_fee_status=$aug_fee_status + $transport_fee['august'];
                $sep_fee_status=$sep_fee_status + $transport_fee['september'];
                $oct_fee_status=$oct_fee_status + $transport_fee['october'];
                $nov_fee_status=$nov_fee_status + $transport_fee['november'];
                $dec_fee_status=$dec_fee_status + $transport_fee['december'];
                $jan_fee_status=$jan_fee_status + $transport_fee['january'];
                $feb_fee_status=$feb_fee_status + $transport_fee['february'];
                $mar_fee_status=$mar_fee_status + $transport_fee['march'];
            }
        }
        
        if($apr_status ==1 && $apr_fee_status ==0){
              echo "<div class='month-item'>
                        <label class='form-group-1'>Apr
                            <input type='checkbox' name='4'  value='".$fee_amount."' class='fee' id='4' month='april' onclick='myFunction()'>
                            <span class='checkmark'></span>
                            <span value=".$fee_amount." class='4' id='april'></span>
                        </label>
                    </div>"; 
        }
        
        if($may_status ==1 && $may_fee_status ==0){
              echo "<div class='month-item'>
                        <label class='form-group-1'>May
                            <input type='checkbox' name='5'  value='".$fee_amount."' class='fee' id='5' month='may' onclick='myFunction()'>
                            <span class='checkmark'></span>
                            <span value=".$fee_amount." class='5' id='may'></span>
                        </label>
                    </div>"; 
        }
        
        if($jun_status ==1 & $jun_fee_status ==0){
              echo "<div class='month-item'>
                        <label class='form-group-1'>Jun
                            <input type='checkbox' name='6'  value='".$fee_amount."' class='fee' id='6' month='june' onclick='myFunction()'>
                            <span class='checkmark'></span>
                            <span value=".$fee_amount." class='6' id='june'></span>
                        </label>
                    </div>"; 
        }
        
        if($jul_status ==1 & $jul_fee_status ==0){
              echo "<div class='month-item'>
                        <label class='form-group-1'>Jul
                            <input type='checkbox' name='7'  value='".$fee_amount."' class='fee' id='7' month='july' onclick='myFunction()'>
                            <span class='checkmark'></span>
                            <span value=".$fee_amount." class='7' id='july'></span>
                        </label>
                    </div>"; 
        }

        if($aug_status ==1 & $aug_fee_status ==0){
              echo "<div class='month-item'>
                        <label class='form-group-1'>Aug
                            <input type='checkbox' name='8'  value='".$fee_amount."' class='fee' id='8' month='august' onclick='myFunction()'>
                            <span class='checkmark'></span>
                            <span value=".$fee_amount." class='8' id='august'></span>
                        </label>
                    </div>"; 
        }

        if($sep_status ==1 & $sep_fee_status ==0){
              echo "<div class='month-item'>
                        <label class='form-group-1'>Sep
                            <input type='checkbox' name='9'  value='".$fee_amount."' class='fee' id='9' month='september' onclick='myFunction()'>
                            <span class='checkmark'></span>
                            <span value=".$fee_amount." class='9' id='september'></span>
                        </label>
                    </div>"; 
        }
        
        if($oct_status ==1 & $oct_fee_status ==0){
              echo "<div class='month-item'>
                        <label class='form-group-1'>Oct
                            <input type='checkbox' name='10'  value='".$fee_amount."' class='fee' id='10' month='october' onclick='myFunction()'>
                            <span class='checkmark'></span>
                            <span value=".$fee_amount." class='10' id='april'></span>
                        </label>
                    </div>"; 
        }

        if($nov_status ==1 & $nov_fee_status ==0){
              echo "<div class='month-item'>
                        <label class='form-group-1'>Nov
                            <input type='checkbox' name='11'  value='".$fee_amount."' class='fee' id='11' month='november' onclick='myFunction()'>
                            <span class='checkmark'></span>
                            <span value=".$fee_amount." class='11' id='november'></span>
                        </label>
                    </div>"; 
        }
        
        if($dec_status ==1 & $dec_fee_status ==0){
              echo "<div class='month-item'>
                        <label class='form-group-1'>Dec
                            <input type='checkbox' name='12'  value='".$fee_amount."' class='fee' id='12' month='december' onclick='myFunction()'>
                            <span class='checkmark'></span>
                            <span value=".$fee_amount." class='12' id='december'></span>
                        </label>
                    </div>"; 
        }        

        if($jan_status ==1 & $jan_fee_status ==0){
              echo "<div class='month-item'>
                        <label class='form-group-1'>Jan
                            <input type='checkbox' name='1'  value='".$fee_amount."' class='fee' id='1' month='january' onclick='myFunction()'>
                            <span class='checkmark'></span>
                            <span value=".$fee_amount." class='1' id='january'></span>
                        </label>
                    </div>"; 
        }
        
        if($feb_status ==1 & $feb_fee_status ==0){
              echo "<div class='month-item'>
                        <label class='form-group-1'>Feb
                            <input type='checkbox' name='2'  value='".$fee_amount."' class='fee' id='2' month='february' onclick='myFunction()'>
                            <span class='checkmark'></span>
                            <span value=".$fee_amount." class='2' id='february'></span>
                        </label>
                    </div>"; 
        }        

        if($mar_status ==1 & $mar_fee_status ==0){
              echo "<div class='month-item'>
                        <label class='form-group-1'>Mar
                            <input type='checkbox' name='3'  value='".$fee_amount."' class='fee' id='3' month='march' onclick='myFunction()'>
                            <span class='checkmark'></span>
                            <span value=".$fee_amount." class='3' id='march'></span>
                        </label>
                    </div>"; 
        }
        
    }
    
    public function get_prev_balance_fee(){
        $sid=$_POST['sid'];
        $acedemic_session=$_POST['acedemic_session'];
        $prevbalfeeamount=0;
        $get_prev_bal_fee_amount=$this->TransportModel->get_prev_bal_fee_amount($sid,$acedemic_session);
        if($get_prev_bal_fee_amount){
           foreach($get_prev_bal_fee_amount as $prev_bal_fee_amount){
               $prevbalfeeamount =$prevbalfeeamount + $prev_bal_fee_amount['balance_fee'];
           }
        }
        echo $prevbalfeeamount;
        
    }
    
    public function get_prev_extra_fee(){
        $sid=$_POST['sid'];
        $acedemic_session=$_POST['acedemic_session'];
        $prev_extra_fee=0;
        $get_prev_extra_fee_amount=$this->TransportModel->get_prev_extra_fee_amount($sid,$acedemic_session);
        if($get_prev_extra_fee_amount){
            foreach($get_prev_extra_fee_amount as $prev_extra_fee_amount){
                $prev_extra_fee=$prev_extra_fee + $prev_extra_fee_amount['extra_fee'];
            }
        }
        echo $prev_extra_fee;
    }
    
    public function get_student_transport_fee_invoices(){
        $sid=$_POST['sid'];
        $acedemic_session=$_POST['acedemic_session'];
        
        $get_student_invoices=$this->TransportModel->get_transport_fee($sid,$acedemic_session);
        if($get_student_invoices){
        echo "<table class='table table-bordered table-striped'>";
            echo "<thead>"; 
                echo '<th>Fee No</th>';
                echo '<th>Est. Fee</th>';
                echo '<th>Prev. Bal.</th>';
                echo '<th>Prev. Extra</th>';
                echo '<th>Discount</th>';
                echo '<th>Received</th>';
                echo '<th>Bal.</th>';
                echo '<th>Extra</th>';
                echo '<th>Fee Date</th>';
                echo '<th>Invoice</th>';
                echo '<th>Edit</th>';
            echo "</thead>";    
            echo "<tbody>";
            foreach($get_student_invoices as $student_invoices){
                
                echo "<tr>";
                    echo '<td>'.$student_invoices['id'].'</td>';
                    echo '<td>'.$student_invoices['esatimate_fee'].'</td>';
                    echo '<td>'.$student_invoices['prev_bal_added'].'</td>';
                    echo '<td>'.$student_invoices['extra_amount_used'].'</td>';
                    echo '<td>'.$student_invoices['discount'].'</td>';
                    echo '<td>'.$student_invoices['received_fee'].'</td>';
                    echo '<td>'.$student_invoices['balance_fee'].'</td>';
                    echo '<td>'.$student_invoices['extra_fee'].'</td>';
                    echo '<td>'.date('d-M-Y',strtotime($student_invoices['fee_date'])).'</td>';
                    echo '<td>
                            <a href="'.base_url().'Transport/invoice/'.$student_invoices['id'].'" style="color:#fff;" class="btn btn-sm btn-danger" target="_blank">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-pdf-fill" viewBox="0 0 16 16">
                                    <path d="M5.523 10.424c.14-.082.293-.162.459-.238a7.878 7.878 0 0 1-.45.606c-.28.337-.498.516-.635.572a.266.266 0 0 1-.035.012.282.282 0 0 1-.026-.044c-.056-.11-.054-.216.04-.36.106-.165.319-.354.647-.548zm2.455-1.647c-.119.025-.237.05-.356.078a21.035 21.035 0 0 0 .5-1.05 11.96 11.96 0 0 0 .51.858c-.217.032-.436.07-.654.114zm2.525.939a3.888 3.888 0 0 1-.435-.41c.228.005.434.022.612.054.317.057.466.147.518.209a.095.095 0 0 1 .026.064.436.436 0 0 1-.06.2.307.307 0 0 1-.094.124.107.107 0 0 1-.069.015c-.09-.003-.258-.066-.498-.256zM8.278 4.97c-.04.244-.108.524-.2.829a4.86 4.86 0 0 1-.089-.346c-.076-.353-.087-.63-.046-.822.038-.177.11-.248.196-.283a.517.517 0 0 1 .145-.04c.013.03.028.092.032.198.005.122-.007.277-.038.465z"/>
                                    <path fill-rule="evenodd" d="M4 0h8a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2zm.165 11.668c.09.18.23.343.438.419.207.075.412.04.58-.03.318-.13.635-.436.926-.786.333-.401.683-.927 1.021-1.51a11.64 11.64 0 0 1 1.997-.406c.3.383.61.713.91.95.28.22.603.403.934.417a.856.856 0 0 0 .51-.138c.155-.101.27-.247.354-.416.09-.181.145-.37.138-.563a.844.844 0 0 0-.2-.518c-.226-.27-.596-.4-.96-.465a5.76 5.76 0 0 0-1.335-.05 10.954 10.954 0 0 1-.98-1.686c.25-.66.437-1.284.52-1.794.036-.218.055-.426.048-.614a1.238 1.238 0 0 0-.127-.538.7.7 0 0 0-.477-.365c-.202-.043-.41 0-.601.077-.377.15-.576.47-.651.823-.073.34-.04.736.046 1.136.088.406.238.848.43 1.295a19.707 19.707 0 0 1-1.062 2.227 7.662 7.662 0 0 0-1.482.645c-.37.22-.699.48-.897.787-.21.326-.275.714-.08 1.103z"/>
                                </svg>
                            </a>
                        </td>';
                        echo '<td><a href="'.base_url().'Transport/edit_fee/'.$student_invoices['id'].'" class="btn btn-outline-warning btn-sm">Edit</a></td>';
                echo "</tr>";
                
            }
            echo "</tbody>";
        echo "</table>";            
        }
    }
    
    public function invoice($fee_no){
        $this->load->view('erp/transport/invoice');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A5', 'landscape');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$fee_no", array("Attachment"=>0));
    }
    
    public function invoices(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/transport/list-invoices');
        $this->load->view('erp/footer');
    }
    
    public function pay(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        // $this->load->view('erp/transport/fee');
        $this->load->view('erp/transport/pay-fee');
        $this->load->view('erp/footer');
    }
    
    public function update_fee(){
        $fee_id =$_POST['fee_id'];
        // $sid =$_POST['sid'];
        // $acedemic_session =$_POST['acedemic_session'];
        $est_amount =$_POST['est_amount'];
        $prev_extra_amount =$_POST['prev_extra_amount'];
        $prev_bal_amount =$_POST['prev_bal_amount'];
        $discount_amount =$_POST['discount_amount'];
        $received_fee =$_POST['received_fee'];
        $fee_date =$_POST['fee_date'];
        $bal_fee =$_POST['bal_fee'];
        $extra_fee =$_POST['extra_fee'];
        $fee_mode =$_POST['fee_mode'];
        $fee_note =$_POST['fee_note'];
        $transaction_info =$_POST['transaction_info'];
        $route_id =$_POST['route_i'];
        
        $cat=date("Y-m-d H:i:s");
        $tid=$this->session->userdata("tid");
        
        $data_array_update=array(
            "received_fee"=>$received_fee,
            "route_id"=>$route_id,
            "extra_fee"=>$extra_fee,
            "balance_fee"=>$bal_fee,
            "fee_date"=>$fee_date,
            "discount"=>$discount_amount,
            "fee_mode"=>$fee_mode,
            "fee_note"=>$fee_note,
            "transaction_info"=>$transaction_info,
            "uat"=>$cat,
            "upd_by"=>$tid
        );
        $table="transport_fee";
        $update_fee_data=$this->TransportModel->update_item_data($fee_id,$data_array_update,$table);
        if($update_fee_data){
            echo "Updated Successfully";
        }else{
            echo "Some Error Occured";
            var_dump($data_array_update);
        }
    }
    
    
    public function delete_invoice(){
        $invoice_id=$_POST['invoice_id'];
        $table="transport_fee";
        $get_invoice_data=$this->TransportModel->get_item_data($invoice_id,$table);
        $cat=date("Y-m-d H:i:s");
        $tid=$this->session->userdata("tid");
        if($get_invoice_data){
            foreach($get_invoice_data as $invoices_data){
                
                $data_array=array(
                    "invoice_id"=>$invoice_id,
                    "sid"=>$invoices_data['sid'],
                    "acedemic_session"=>$invoices_data['acedemic_session'],
                    "fee_type"=>$invoices_data['fee_type'],
                    "route_id"=>$invoices_data['route_id'],
                    "esatimate_fee"=>$invoices_data['esatimate_fee'],
                    "received_fee"=>$invoices_data['received_fee'],
                    "extra_fee"=>$invoices_data['extra_fee'],
                    "extra_fee_status"=>$invoices_data['extra_fee_status'],
                    "balance_fee"=>$invoices_data['balance_fee'],
                    "balance_fee_status"=>$invoices_data['balance_fee_status'],
                    "april"=>$invoices_data['april'],
                    "may"=>$invoices_data['may'],
                    "june"=>$invoices_data['june'],
                    "july"=>$invoices_data['july'],
                    "august"=>$invoices_data['august'],
                    "september"=>$invoices_data['september'],
                    "october"=>$invoices_data['october'],
                    "november"=>$invoices_data['november'],
                    "december"=>$invoices_data['december'],
                    "january"=>$invoices_data['january'],
                    "february"=>$invoices_data['february'],
                    "march"=>$invoices_data['march'],
                    "fee_date"=>$invoices_data['fee_date'],
                    "prev_bal_added"=>$invoices_data['prev_bal_added'],
                    "prev_bal_added_refrence"=>$invoices_data['prev_bal_added_refrence'],
                    "extra_amount_used"=>$invoices_data['extra_amount_used'],
                    "extra_amount_used_refrence"=>$invoices_data['extra_amount_used_refrence'],
                    "discount"=>$invoices_data['discount'],
                    "fee_months"=>$invoices_data['fee_months'],
                    "fee_mode"=>$invoices_data['fee_mode'],
                    "fee_note"=>$invoices_data['fee_note'],
                    "transaction_info"=>$invoices_data['transaction_info'],
                    "cat"=>$invoices_data['cat'],
                    "cat_by"=>$invoices_data['cat_by'],
                    "uat"=>$invoices_data['uat'],
                    "upd_by"=>$invoices_data['upd_by'],
                    "deleted_at"=>$cat,
                    "deleted_by"=>$tid
                );
                $deleted_table="transport_fee_deleted";
                $add_deleted_invoice=$this->TransportModel->insert_data($data_array,$deleted_table);
                if($add_deleted_invoice){
                    $delete_invoice=$this->TransportModel->delete_item($invoice_id,$table);
                    $response_array=array("error"=>false,"msg"=>"Invoice Deleted Successfully");
        
        
                    echo json_encode($response_array);
                }
            }
        }
        
        
    }
    
    public function deleted_invoices(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/transport/list-deleted-transport-invoices');
        $this->load->view('erp/transport/edit-fee');
        $this->load->view('erp/footer');
    }
    
    public function deleted_invoice($fee_no){
        $this->load->view('erp/transport/deleted-invoice');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A5', 'landscape');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$fee_no", array("Attachment"=>0));
    }
}       