<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class TimeTableManagement extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('SchoolModel');
        $this->load->model('StudentModel');
        // $this->load->model('FeeModel');
        $this->load->model('AttendenceModel');
        $this->load->model('CalenderModel');
        $this->load->model('WelcomeModel');
        $this->load->model('NewFeeModel');
        $this->load->model('DeveloperModel');
        $this->load->model('TimeTableModel');
        $this->load->helper('date');
        $this->load->database();    
        $this->load->library('form_validation');
        $this->load->helper(array('form', 'url'));
        $this->load->library('session');
        $this->load->library('Pdf');
    }
    
    public function index(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/time_table/index');
        $this->load->view('erp/footer');
    }
    
    public function add_new(){
        $data['success']=""; 
        $data['error']="";
        if(isset($_POST['add_time_table'])){
            
            $title=$_POST['title'];
            $acedemic_session=$_POST['acedemic_session'];
            $academic_session_table="academic_session_details";
            $ace_session_data=$this->TimeTableModel->get_item_data($acedemic_session,$academic_session_table);
            if($ace_session_data){
                foreach($ace_session_data as $sess_data){
                    $y1=$sess_data['y1'];
                    $y2=$sess_data['y2'];
                }
            }
            $cat=date("Y-m-d H:i:s");
            $tid=$this->session->userdata("tid");
            $april=0;
            if(isset($_POST['april'])){
                $april=$_POST['april'];
            }
            $may=0;
            if(isset($_POST['may'])){
                $may=$_POST['may'];
            }
            $june=0;
            if(isset($_POST['june'])){
                $june=$_POST['june'];
            }
            $july=0;
            if(isset($_POST['july'])){
                $july=$_POST['july'];
            }
            $august=0;
            if(isset($_POST['august'])){
                $august=$_POST['august'];
            }
            $september=0;
            if(isset($_POST['september'])){
                $september=$_POST['september'];
            }
            $october=0;
            if(isset($_POST['october'])){
                $october=$_POST['october'];
            }
            $november=0;
            if(isset($_POST['november'])){
                $november=$_POST['november'];
            }
            $december=0;
            if(isset($_POST['december'])){
                $december=$_POST['december'];
            }
            $january=0;
            if(isset($_POST['january'])){
                $january=$_POST['january'];
            }
            $february=0;
            if(isset($_POST['february'])){
                $february=$_POST['february'];
            }
            $march=0;
            if(isset($_POST['march'])){
                $march=$_POST['march'];
            }
            
            $data_array=array(
                "title"=>$title,
                "acedemic_session"=>$acedemic_session,
                "y1"=>$y1,
                "y2"=>$y2,
                "april"=>$april,
                "may"=>$may,
                "june"=>$june,
                "july"=>$july,
                "august"=>$august,
                "september"=>$september,
                "october"=>$october,
                "november"=>$november,
                "december"=>$december,
                "january"=>$january,
                "february"=>$february,
                "march"=>$march,
                "created_at"=>$cat,
                "created_by"=>$tid,
                "updated_at"=>$cat,
                "updated_by"=>$tid
            );
            
            $table="time_table";
            $add_new_time_table=$this->TimeTableModel->insert_data($table,$data_array);
            if($add_new_time_table){
                $data['success']="Time table added successfully !";
            }else{
                $data['error']="Error in adding time table !";
            }
            
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/time_table/add-new',$data);
        $this->load->view('erp/footer');
    }
    
    public function periods(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/time_table/periods');
        $this->load->view('erp/footer');
    }
    
    public function add_new_period(){
        $time_table_id=$_POST['time_table_id'];
        $period_number=$_POST['period_number'];
        $period_title=$_POST['period_title'];
        $start_time=$_POST['start_time'];
        $end_time=$_POST['end_time'];
        
        $cat=date("Y-m-d H:i:s");
        $tid=$this->session->userdata("tid");
        
        $data_array=array(
            "time_table_id"=>$time_table_id,
            "period"=>$period_title,
            "period_order"=>$period_number,
            "start_time"=>$start_time,
            "end_time"=>$end_time,
            "created_at"=>$cat,
            "created_by"=>$tid,
            "updated_at"=>$cat,
            "updated_by"=>$tid
        );
        
        $table="time_table_periods";
        
        $add_new_period=$this->TimeTableModel->insert_data($table,$data_array);
        if($add_new_period){
            echo "success";
        }else{
            echo "some error occured inadding new period";
        }
    }
    
    public function add_time_table_records(){
        $data['success']='';
        $data['error']='';
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/time_table/add_time_table_records',$data);
        // $this->load->view("erp/time_table/time-table");
        $this->load->view('erp/footer');
    }
    
    public function time_table_view(){
        $this->load->view('erp/header');
        // $this->load->view('erp/sidebar');
        $this->load->view("erp/time_table/time-table");
        $this->load->view('erp/footer');
    }
    
    public function generate_time_table(){
        $time_table_id=$_POST['time_table_id'];
        $class=$_POST['class'];
        $section=$_POST['section'];
        $period=$_POST['period'];
        $teacher=$_POST['teacher'];
        $subject=$_POST['subject'];
        $week_days=$_POST['week_day'];
        $count_week_days=count($week_days);
        if($count_week_days >=1){
            for ($i=0; $i<$count_week_days;$i++){
                $week_day=$week_days[$i];
            
                $cat=date("Y-m-d H:i:s");
                $tid=$this->session->userdata('tid');
                $data_array=array(
                    "time_table_id"=>$time_table_id,
                    "period_id"=>$period,
                    "class"=>$class,
                    "section"=>$section,
                    "tid"=>$teacher,
                    "subject"=>$subject,
                    "week_day"=>$week_day,
                    "created_at"=>$cat,
                    "created_by"=>$tid,
                    "updated_at"=>$cat,
                    "updated_by"=>$tid
                );
                $data_array_update=array(
                    "tid"=>$teacher,
                    "subject"=>$subject,
                    "updated_at"=>$cat,
                    "updated_by"=>$tid
                );
                $table="time_table_record";
                $check_record_exists=$this->TimeTableModel->get_time_table_record($time_table_id,$period,$teacher,$week_day);
                if($check_record_exists){
                    echo "/Teacher Already Alloted to other class";
                }else{
                    $check_class_section_record=$this->TimeTableModel->check_class_section_record($time_table_id,$class,$section,$period,$week_day);
                    if($check_class_section_record){
                        $update_record=$this->TimeTableModel->update_class_section_record($time_table_id,$class,$section,$period,$week_day,$data_array_update,$table);
                        if($update_record){
                            echo "/success";
                        }
                    }else{
                        $add_new_record=$this->TimeTableModel->insert_data($table,$data_array);
                        if($add_new_record){
                            echo "/success";
                        }
                    }
            
                }
            }
        }
    }
    
    public function class_subjects(){
        $data['success']=""; $data['error']="";
        if(isset($_POST['add_subject'])){
            $class=$_POST['class'];
            $subject=$_POST['subject'];
            $subject_order=$_POST['subject_order'];
            $status=$_POST['status'];
            $cat=date("Y-m-d H:i:s");
            $tid=$this->session->userdata("tid");
            $data_array=array(
                "class"=>$class,
                "subject"=>$subject,
                "subject_order"=>$subject_order,
                "status"=>$status,
                "created_at"=>$cat,
                "created_by"=>$tid,
                "updated_at"=>$cat,
                "updated_by"=>$tid
            );
            
            $table="subject_master";
            $check_subject_master=$this->TimeTableModel->check_class_subject_data($class,$subject,$table);
            if($check_subject_master){
                $data['error']="Subject already exists.";
            }else{
                $add_new_subject=$this->TimeTableModel->insert_data($table,$data_array);
                if($add_new_subject){
                    $data['success']="Subject Added Successfully.";
                }
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view("erp/time_table/class-subjects",$data);
        $this->load->view('erp/footer');
    }
    
    
    public function subjects(){
        $class="";
        if(isset($_POST['search_subjects'])){
            $class=$_POST['class'];    
        }
        
        
        $data['all_subjects']=$this->TimeTableModel->get_class_subjects($class);
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view("erp/time_table/subjects",$data);
        $this->load->view('erp/footer');
    }
    
    public function get_course_subjects(){
        $class=$_POST['course'];
        $all_subjects=$this->TimeTableModel->get_class_subjects($class);
        $data="";
        if($all_subjects){
            foreach($all_subjects as $subjects){
                $data .='<option value="'.$subjects["subject"].'">'.$subjects["subject"].'</option>';
            }
        }else{
            $data.="<option value=''>No Subject Found</option>";
        }
        
        echo $data;
    }
    
    public function all_teachers(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view("erp/time_table/all_teachers",$data);
        $this->load->view('erp/footer');
    }
    
    public function teacher_time_table(){
        $tid="";
        if(isset($_POST['get_time_table'])){
            $tid=$_POST['tid'];    
        }
        
        
        $data['all_subjects']=$this->TimeTableModel->get_class_subjects($tid);
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view("erp/time_table/teachers_time_table",$data);
        $this->load->view('erp/footer');
    }
    
    public function time_table_pdf($tid,$sch_id){
        $this->load->view('erp/time_table/teachers_time_table_pdf');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A5', 'landscape');
        // Render the HTML as PDF
        $this->pdf->render();
        $doc_name="Teachers-Time-Table-".$tid;
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$doc_name", array("Attachment"=>0));
    }
    
    public function edit_periods(){
        $data['success']="";
        $data['error']="";
        
        if(isset($_POST['update_period_information'])){
            $period_id=$_POST['period_id'];
            $period_no=$_POST['period_no'];
            $period_title=$_POST['period_title'];
            $start_time=$_POST['start_time'];
            $end_time=$_POST['end_time'];
            
            $cat=date("Y-m-d H:i:s");
            $tid=$this->session->userdata("tid");
            
            $data_array_update=array(
                "period_order"=>$period_no,
                "period"=>$period_title,
                "start_time"=>$start_time,
                "end_time"=>$end_time,
                "updated_at"=>$cat,
                "updated_by"=>$tid
            );
            
            $table="time_table_periods";
            $update_item_data=$this->TimeTableModel->update_item_data($period_id,$data_array_update,$table);
            if($update_item_data){
                $data['success']="Period Information Updated Successfully.";
            }else{
                $data["error"]="Error in updating period information.";
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view("erp/time_table/edit-period",$data);
        $this->load->view('erp/footer');
    }
    
    public function class_section_time_table($schedule_id,$class,$section){
        $data['success']="";
        $data['error']="";
        $periods_table="time_table_periods";
        $all_periods=$this->TimeTableModel->get_schedule_periods($schedule_id,$periods_table);
        
        if(isset($_POST['update_course_sch_data'])){
            $mon_schedule_data=$_POST['mon_schedule_data'];
            $tue_schedule_data=$_POST['tue_schedule_data'];
            $wed_schedule_data=$_POST['wed_schedule_data'];
            $thu_schedule_data=$_POST['thu_schedule_data'];
            $fri_schedule_data=$_POST['fri_schedule_data'];
            $sat_schedule_data=$_POST['sat_schedule_data'];
            // echo "<br><br><br><br>";
            if($all_periods){
                foreach($all_periods as $period_data){
                    $sub_master_table="subject_master";
                    
                    $period=$period_data['id'];
                    $week_day_1="MON";
                    $mon_tid=$mon_schedule_data[$period]['teacher'];
                    $mon_subject_id=$mon_schedule_data[$period]['subject_id'];
                    
                    $get_mon_subject_data=$this->TimeTableModel->get_item_data($mon_subject_id,$sub_master_table);
                    $mon_subject="";
                    if($get_mon_subject_data){
                        foreach($get_mon_subject_data as $sub_data){
                            $mon_subject=$sub_data["subject"];
                        }
                    }
                    
                    // echo "Period Id ".$period.", Mon Tid : ".$mon_tid.", SubId : ".$mon_subject_id."<br>";
                    
                    $week_day_2="TUE";
                    $tue_tid=$tue_schedule_data[$period]['teacher'];
                    $tue_subject_id=$tue_schedule_data[$period]['subject_id'];
                    
                    $get_tue_subject_data=$this->TimeTableModel->get_item_data($tue_subject_id,$sub_master_table);
                    $tue_subject="";
                    if($get_tue_subject_data){
                        foreach($get_tue_subject_data as $sub_data){
                            $tue_subject=$sub_data["subject"];
                        }
                    }
                    
                    // echo "Period Id ".$period.", TUE Tid : ".$tue_tid.", SubId : ".$tue_subject_id."<br>";
                    
                    
                    $week_day_3="WED";
                    $wed_tid=$wed_schedule_data[$period]['teacher'];
                    $wed_subject_id=$wed_schedule_data[$period]['subject_id'];
                    
                    $get_wed_subject_data=$this->TimeTableModel->get_item_data($wed_subject_id,$sub_master_table);
                    $wed_subject="";
                    if($get_wed_subject_data){
                        foreach($get_wed_subject_data as $sub_data){
                            $wed_subject=$sub_data["subject"];
                        }
                    }
                    
                    // echo "Period Id ".$period.", WED Tid : ".$wed_tid.", SubId : ".$wed_subject_id."<br>";
                    
                    $week_day_4="THU";
                    $thu_tid=$thu_schedule_data[$period]['teacher'];
                    $thu_subject_id=$thu_schedule_data[$period]['subject_id'];
                    
                    $get_thu_subject_data=$this->TimeTableModel->get_item_data($thu_subject_id,$sub_master_table);
                    $thu_subject="";
                    if($get_thu_subject_data){
                        foreach($get_thu_subject_data as $sub_data){
                            $thu_subject=$sub_data["subject"];
                        }
                    }
                    
                    // echo "Period Id ".$period.", THU Tid : ".$thu_tid.", SubId : ".$thu_subject_id."<br>";
                    
                    
                    $week_day_5="FRI";
                    $fri_tid=$fri_schedule_data[$period]['teacher'];
                    $fri_subject_id=$fri_schedule_data[$period]['subject_id'];
                    
                    $get_fri_subject_data=$this->TimeTableModel->get_item_data($fri_subject_id,$sub_master_table);
                    $fri_subject="";
                    if($get_fri_subject_data){
                        foreach($get_fri_subject_data as $sub_data){
                            $fri_subject=$sub_data["subject"];
                        }
                    }
                    
                    // echo "Period Id ".$period.", FRI Tid : ".$fri_tid.", SubId : ".$fri_subject_id."<br>";
                    
                    $week_day_6="SAT";
                    $sat_tid=$sat_schedule_data[$period]['teacher'];
                    $sat_subject_id=$sat_schedule_data[$period]['subject_id'];
                    
                    $get_sat_subject_data=$this->TimeTableModel->get_item_data($sat_subject_id,$sub_master_table);
                    $sat_subject="";
                    if($get_sat_subject_data){
                        foreach($get_sat_subject_data as $sub_data){
                            $sat_subject=$sub_data["subject"];
                        }
                    }
                    
                    // echo "Period Id ".$period.", SAT Tid : ".$sat_tid.", SubId : ".$sat_subject_id."<br>";
                    
                    
                    $cat=date("Y-m-d H:i:s");
                    $tid=$this->session->userdata('tid');
                    $table="time_table_record";
                    
                    
                    // Monday Record Update
                    $data_array_1=array(
                        "time_table_id"=>$schedule_id,
                        "period_id"=>$period,
                        "class"=>$class,
                        "section"=>$section,
                        "tid"=>$mon_tid,
                        "subject"=>$mon_subject,
                        "subject_id"=>$mon_subject_id,
                        "week_day"=>$week_day_1,
                        "created_at"=>$cat,
                        "created_by"=>$tid,
                        "updated_at"=>$cat,
                        "updated_by"=>$tid
                    );
                    $data_array_update_1=array(
                        "tid"=>$mon_tid,
                        "subject"=>$mon_subject,
                        "subject_id"=>$mon_subject_id,
                        "updated_at"=>$cat,
                        "updated_by"=>$tid
                    );
                    
                    $check_record_exists=$this->TimeTableModel->get_time_table_record($schedule_id,$period,$mon_tid,$week_day_1);
                    if($check_record_exists){
                        $data['p1_d1_error'] =" Teacher Already Alloted to other class. ";
                    }else{
                        $check_class_section_record=$this->TimeTableModel->check_class_section_record($schedule_id,$class,$section,$period,$week_day_1);
                        if($check_class_section_record){
                            $update_record=$this->TimeTableModel->update_class_section_record($schedule_id,$class,$section,$period,$week_day_1,$data_array_update_1,$table);
                            if($update_record){
                                $data['p1_d1_success']= "success";
                            }
                        }else{
                            $add_new_record=$this->TimeTableModel->insert_data($table,$data_array_1);
                            if($add_new_record){
                                $data["p1_d1_success"] = "success";
                            }
                        }
            
                    }
                    
                    
                    // Tuesday Record Update
                    $data_array_2=array(
                        "time_table_id"=>$schedule_id,
                        "period_id"=>$period,
                        "class"=>$class,
                        "section"=>$section,
                        "tid"=>$tue_tid,
                        "subject"=>$tue_subject,
                        "subject_id"=>$tue_subject_id,
                        "week_day"=>$week_day_2,
                        "created_at"=>$cat,
                        "created_by"=>$tid,
                        "updated_at"=>$cat,
                        "updated_by"=>$tid
                    );
                    $data_array_update_2=array(
                        "tid"=>$tue_tid,
                        "subject"=>$tue_subject,
                        "subject_id"=>$tue_subject_id,
                        "updated_at"=>$cat,
                        "updated_by"=>$tid
                    );
                    
                    $check_record_exists=$this->TimeTableModel->get_time_table_record($schedule_id,$period,$tue_tid,$week_day_2);
                    if($check_record_exists){
                        $data['p2_d2_error'] =" Teacher Already Alloted to other class. ";
                    }else{
                        $check_class_section_record=$this->TimeTableModel->check_class_section_record($schedule_id,$class,$section,$period,$week_day_2);
                        if($check_class_section_record){
                            $update_record=$this->TimeTableModel->update_class_section_record($schedule_id,$class,$section,$period,$week_day_2,$data_array_update_2,$table);
                            if($update_record){
                                $data['p2_d2_success']= "success";
                            }
                        }else{
                            $add_new_record=$this->TimeTableModel->insert_data($table,$data_array_2);
                            if($add_new_record){
                                $data["p2_d2_success"] = "success";
                            }
                        }
            
                    }
                    
                    
                    // Wednesday Record Update
                    $data_array_3=array(
                        "time_table_id"=>$schedule_id,
                        "period_id"=>$period,
                        "class"=>$class,
                        "section"=>$section,
                        "tid"=>$wed_tid,
                        "subject"=>$wed_subject,
                        "subject_id"=>$wed_subject_id,
                        "week_day"=>$week_day_3,
                        "created_at"=>$cat,
                        "created_by"=>$tid,
                        "updated_at"=>$cat,
                        "updated_by"=>$tid
                    );
                    $data_array_update_3=array(
                        "tid"=>$wed_tid,
                        "subject"=>$wed_subject,
                        "subject_id"=>$wed_subject_id,
                        "updated_at"=>$cat,
                        "updated_by"=>$tid
                    );
                    
                    $check_record_exists=$this->TimeTableModel->get_time_table_record($schedule_id,$period,$wed_tid,$week_day_3);
                    if($check_record_exists){
                        $data['p3_d3_error'] =" Teacher Already Alloted to other class. ";
                    }else{
                        $check_class_section_record=$this->TimeTableModel->check_class_section_record($schedule_id,$class,$section,$period,$week_day_3);
                        if($check_class_section_record){
                            $update_record=$this->TimeTableModel->update_class_section_record($schedule_id,$class,$section,$period,$week_day_3,$data_array_update_3,$table);
                            if($update_record){
                                $data['p3_d3_success']= "success";
                            }
                        }else{
                            $add_new_record=$this->TimeTableModel->insert_data($table,$data_array_3);
                            if($add_new_record){
                                $data["p3_d3_success"] = "success";
                            }
                        }
            
                    }
                    
                    
                    
                    // Thursday Record Update
                    $data_array_4=array(
                        "time_table_id"=>$schedule_id,
                        "period_id"=>$period,
                        "class"=>$class,
                        "section"=>$section,
                        "tid"=>$thu_tid,
                        "subject"=>$thu_subject,
                        "subject_id"=>$thu_subject_id,
                        "week_day"=>$week_day_4,
                        "created_at"=>$cat,
                        "created_by"=>$tid,
                        "updated_at"=>$cat,
                        "updated_by"=>$tid
                    );
                    $data_array_update_4=array(
                        "tid"=>$thu_tid,
                        "subject"=>$thu_subject,
                        "subject_id"=>$thu_subject_id,
                        "updated_at"=>$cat,
                        "updated_by"=>$tid
                    );
                    
                    $check_record_exists=$this->TimeTableModel->get_time_table_record($schedule_id,$period,$thu_tid,$week_day_4);
                    if($check_record_exists){
                        $data['p4_d4_error'] =" Teacher Already Alloted to other class. ";
                    }else{
                        $check_class_section_record=$this->TimeTableModel->check_class_section_record($schedule_id,$class,$section,$period,$week_day_4);
                        if($check_class_section_record){
                            $update_record=$this->TimeTableModel->update_class_section_record($schedule_id,$class,$section,$period,$week_day_4,$data_array_update_4,$table);
                            if($update_record){
                                $data['p3_d3_success']= "success";
                            }
                        }else{
                            $add_new_record=$this->TimeTableModel->insert_data($table,$data_array_4);
                            if($add_new_record){
                                $data["p4_d4_success"] = "success";
                            }
                        }
            
                    }
                
                    
                    
                    // Friday Record Update
                    $data_array_5=array(
                        "time_table_id"=>$schedule_id,
                        "period_id"=>$period,
                        "class"=>$class,
                        "section"=>$section,
                        "tid"=>$fri_tid,
                        "subject"=>$fri_subject,
                        "subject_id"=>$fri_subject_id,
                        "week_day"=>$week_day_5,
                        "created_at"=>$cat,
                        "created_by"=>$tid,
                        "updated_at"=>$cat,
                        "updated_by"=>$tid
                    );
                    $data_array_update_5=array(
                        "tid"=>$fri_tid,
                        "subject"=>$fri_subject,
                        "subject_id"=>$fri_subject_id,
                        "updated_at"=>$cat,
                        "updated_by"=>$tid
                    );
                    
                    $check_record_exists=$this->TimeTableModel->get_time_table_record($schedule_id,$period,$fri_tid,$week_day_5);
                    if($check_record_exists){
                        $data['p5_d5_error'] =" Teacher Already Alloted to other class. ";
                    }else{
                        $check_class_section_record=$this->TimeTableModel->check_class_section_record($schedule_id,$class,$section,$period,$week_day_5);
                        if($check_class_section_record){
                            $update_record=$this->TimeTableModel->update_class_section_record($schedule_id,$class,$section,$period,$week_day_5,$data_array_update_5,$table);
                            if($update_record){
                                $data['p5_d5_success']= "success";
                            }
                        }else{
                            $add_new_record=$this->TimeTableModel->insert_data($table,$data_array_5);
                            if($add_new_record){
                                $data["p5_d5_success"] = "success";
                            }
                        }
            
                    }
                    
                    
                    // Saturday Record Update
                    $data_array_6=array(
                        "time_table_id"=>$schedule_id,
                        "period_id"=>$period,
                        "class"=>$class,
                        "section"=>$section,
                        "tid"=>$sat_tid,
                        "subject"=>$sat_subject,
                        "subject_id"=>$sat_subject_id,
                        "week_day"=>$week_day_6,
                        "created_at"=>$cat,
                        "created_by"=>$tid,
                        "updated_at"=>$cat,
                        "updated_by"=>$tid
                    );
                    $data_array_update_6=array(
                        "tid"=>$sat_tid,
                        "subject"=>$sat_subject,
                        "subject_id"=>$sat_subject_id,
                        "updated_at"=>$cat,
                        "updated_by"=>$tid
                    );
                    
                    $check_record_exists=$this->TimeTableModel->get_time_table_record($schedule_id,$period,$sat_tid,$week_day_6);
                    if($check_record_exists){
                        $data['p6_d6_error'] =" Teacher Already Alloted to other class. ";
                    }else{
                        $check_class_section_record=$this->TimeTableModel->check_class_section_record($schedule_id,$class,$section,$period,$week_day_6);
                        if($check_class_section_record){
                            $update_record=$this->TimeTableModel->update_class_section_record($schedule_id,$class,$section,$period,$week_day_6,$data_array_update_6,$table);
                            if($update_record){
                                $data['p6_d6_success']= "success";
                            }
                        }else{
                            $add_new_record=$this->TimeTableModel->insert_data($table,$data_array_6);
                            if($add_new_record){
                                $data["p6_d6_success"] = "success";
                            }
                        }
            
                    }
                    
                    
                    
                }
            }
            
            // echo $section;
            // echo json_encode($mon_schedule_data);
        }
        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view("erp/time_table/class-section-time-table",$data);
        $this->load->view('erp/footer');
    }
    
    public function teachers_active_time_table(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view("erp/time_table/teacher-active-time-table",$data);
        $this->load->view('erp/footer');
    }
    
}