<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Student extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('StudentModel');
        $this->load->model('FeeModel');
        $this->load->model('SchoolModel');
        $this->load->model('WelcomeModel');
        $this->load->model('NewFeeModel');
        $this->load->model('InvoiceModel');
        $this->load->helper('date');
        $this->load->database();
        $this->load->library('form_validation');
        $this->load->helper(array('form', 'url'));
        $this->load->library('session');
        $this->load->library('Pdf');
    }

    public function index(){
        if($this->session->userdata('document')==1 || $this->session->userdata('all_permission')==1 || $this->session->userdata('admin')==1){
        }else{redirect(base_url().'Login/');}
        $this->load->view('erp/header');
        // $this->load->view('erp/staff-nav');
        $this->load->view('erp/sidebar');
        // $this->load->view('erp/student/dashboard');
        $this->load->view('erp/students/all-student');
        $this->load->view('erp/footer');    
    }

    public function add_new_student(){
        if( $this->session->userdata('admin')==1 || $this->session->userdata('fee')==1 || $this->session->userdata('class_teacher')!=''){
            
        }else{
            redirect(base_url()."Logout");
        }   


        $month = date('M');    
        $day = date('D'); 
        $year = date('Y'); 
        $data['success'] = ''; $data['error'] = '';
        $data['student_course_data_status_1']='';
        $data['student_course_data_status_2']='';
        if(isset($_POST['edit'])){
            $data['data'] = $_POST['edit'];
        }


        if(isset($_POST['add_student'])){
            $uat=date('Y-m-d H:i:s');
            $student_class='';
            $course_stream='';
            $course_id=$this->input->post('course_id');
            $course_table='courses';
            $get_course_data=$this->StudentModel->get_item_data($course_id,$course_table);
            if($get_course_data){
                foreach($get_course_data as $course_info){
                    $student_class=$course_info['course'];
                    $course_stream=$course_info['subject_stream'];
                }
            }
    
    
            $id = $this->input->post('id');
            $student_name = htmlspecialchars($this->input->post('student_name'));
            $gender = htmlspecialchars($this->input->post('gender'));
            $father_name = htmlspecialchars($this->input->post('father_name'));
            $mother_name = htmlspecialchars($this->input->post('mother_name'));
            $date = date('y-m-d H:i:s');    
            $residence_address =htmlspecialchars($this->input->post('residence_address'));
            $office_name_address = htmlspecialchars($this->input->post('office_name_address'));
            $phone_resi = htmlspecialchars($this->input->post('phone_resi'));
            $phone_office=htmlspecialchars($this->input->post('phone_office'));
            $admission_for_class=htmlspecialchars($this->input->post('admission_for_class'));
            $section = htmlspecialchars($this->input->post('section'));
            $previous_school = htmlspecialchars($this->input->post('previous_school'));
            $previous_examination_appeared = htmlspecialchars($this->input->post('previous_examination_appeared'));
            $previous_exam_result = htmlspecialchars($this->input->post('previous_exam_result'));
            $d_o_b = htmlspecialchars($this->input->post('d_o_b'));
            $scholar_no = htmlspecialchars($this->input->post('scholar_no'));
            $religion = htmlspecialchars($this->input->post('religion'));
            $caste = htmlspecialchars($this->input->post('caste'));
            $admission_date = htmlspecialchars($this->input->post('admission_date'));
            $email = htmlspecialchars($this->input->post('email'));
            // $student_class =htmlspecialchars($this->input->post('student_class')); 
            $slug = $this->slugify($student_name);
            $bill_book_number = $this->input->post('bill_book_number');
            $blood_group=$_POST['blood_group'];
            
            $data_array=array("student_name"=>$student_name,"gender"=>$gender,"father_name"=>$father_name,"mother_name"=>$mother_name,"sch_no"=>$scholar_no,"admission_date"=>$admission_date,"month"=>$month,"day"=>$day,"address"=>$residence_address,"cat"=>$date,"office_address"=>$office_name_address,"contact_no"=>$phone_resi,"class"=>$student_class,"section"=>$section,"alternate_no"=>$phone_office,"admission_class"=>$admission_for_class,"year"=>$year,"previous_exam"=>$previous_examination_appeared,"previous_exam_result"=>$previous_exam_result,"previous_school"=>$previous_school,"religion"=>$religion,"caste"=>$caste,"email"=>$email,"dob"=>$d_o_b,"slug"=>$slug,"bill_book_number"=>$bill_book_number,"course_id"=>$course_id,"course_stream"=>$course_stream,"blood_group"=>$blood_group);

            $table = 'student';
        
            $student_courses_table='student_courses_data';
    
            $student_course_data_array_update=array("course_id"=>$course_id,"class"=>$student_class,"section"=>$section,"uat"=>$uat,"upd_by"=>$this->session->userdata('tid'));
        
            $check_student = $this->StudentModel->check_student($id,$table); 
    
            $acedemic_session=$this->session->userdata('acedemic_session');

            if($check_student){
                $data_array_update=array("student_name"=>$student_name,"gender"=>$gender,"father_name"=>$father_name,"mother_name"=>$mother_name,"cat"=>$date,"sch_no"=>$scholar_no,"admission_date"=>$admission_date,"month"=>$month,"day"=>$day,"address"=>$residence_address,"office_address"=>$office_name_address,"contact_no "=>$phone_resi,"alternate_no"=>$phone_office,"class"=>$student_class,"section"=>$section,"admission_class"=>$admission_for_class,"year"=>$year,"previous_exam"=>$previous_examination_appeared,"previous_exam_result"=>$previous_exam_result,"previous_school"=>$previous_school,"religion"=>$religion,"caste"=>$caste,"email"=>$email,"dob"=>$d_o_b,"slug"=>$slug,"bill_book_number"=>$bill_book_number,"course_id"=>$course_id,"course_stream"=>$course_stream,"blood_group"=>$blood_group);

                $update_student=$this->StudentModel->update_student($id,$table,$data_array_update);
                if($update_student){
                    $data['success'] = 'Student Record Updated Successfully.'; 
                    // redirect(base_url().'student/profile/'.$id);
                    //  $data['success'] = $icon.''.$new_icon; 
                
                    $check_student_courses_data=$this->StudentModel->get_student_courses_data_by_acedemic_session($id,$acedemic_session);
                    if($check_student_courses_data){
                        $update_student_courses_data=$this->StudentModel->update_student_courses_data($id,$acedemic_session,$student_course_data_array_update,$student_courses_table);
                        if($update_student_courses_data){
                            $data['student_course_data_status_1']='Student Courses Data Updated Successfully !';
                        }else{
                            $data['student_course_data_status_2']='Error in updating student courses data !';
                        }
                    }else{
                        $student_course_data_array=array("sid"=>$sid,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"class"=>$student_class,"section"=>$section,"uat"=>$uat,"upd_by"=>$this->session->userdata('tid'));
                        $add_student_to_courses_data=$this->StudentModel->insert_data($student_course_data_array,$student_courses_table);
                        if($add_student_to_courses_data){
                            $data['student_course_data_status_1']='Student Added in student courses data successfully';
                        }else{
                            $data['student_course_data_status_2']='Error in adding student in student courses data !';
                        }
                    }
                }else{
                    $data['error'] = 'Error in updating student data';
                }
            }else{
                $add_new_student = $this->StudentModel->add_new_student($table,$data_array);
                if($add_new_student){
                    $data['success'] = 'Student Added Successfully.'; 
                    $student_course_data_array=array("sid"=>$add_new_student,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"class"=>$student_class,"section"=>$section,"uat"=>$uat,"upd_by"=>$this->session->userdata('tid'));
                    $add_student_to_courses_data=$this->StudentModel->insert_data($student_course_data_array,$student_courses_table);
                    if($add_student_to_courses_data){
                        $data['student_course_data_status_1']='Student Added in student courses data successfully';
                        // redirect(base_url().'student/profile/'.$add_new_student);
                    }else{
                        $data['student_course_data_status_2']='Error in adding student in student courses data !';
                    }
                }else{
                    $data['error'] = 'Failed To Add Student';
                }
            }
        }

        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/students/add-student',$data);
        $this->load->view('erp/footer');
    }


    public function slugify($text){
        // replace non letter or digits by -
        $text = preg_replace('~[^\pL\d]+~u', '-', $text);
        // transliterate
        $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);

        // remove unwanted characters
        $text = preg_replace('~[^-\w]+~', '', $text);

        // trim
        $text = trim($text, '-');

        // remove duplicate -
        $text = preg_replace('~-+~', '-', $text);

        // lowercase
        $text = strtolower($text);
        if(empty($text)){
            return 'n-a';
        }

        return $text;
    }   

    public function profile($sid){
        $this->load->view('erp/header');
        // $this->load->view('erp/staff-nav');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/teachers/my-class-single-student');
        $this->load->view('erp/footer');    
    }
    public function student_docs(){
        $this->load->view('entab/feemanagement/user/header');
        $this->load->view('entab/nav');
        $this->load->view('entab/students/dashboard');
        $this->load->view('entab/students/all-student');
        $this->load->view('entab/feemanagement/user/footer');      
    }
    public function leaving_certificate(){
        if($this->session->userdata('admin')!=1){
            redirect(base_url().'login/');
        }     
        $datee= date('d-M-Y');
        if($this->uri->segment(3)){
            $id = $this->uri->segment(3);}
  
        $old_limit = ini_set("memory_limit", "64M");
        $dompdf = new Pdf();
        
        $dompdf->set_paper('letter', 'portrait'); //landscape , portrait



        $html_content=$this->FeeModel->pdf_header();
        // background-color:#fcb19f;
        $html_content .='<div class="col-sm-12" style="border:1px solid;padding-top:20px;">';
        $html_content .= '<div class=" ">';
        $html_content .="<table class='' width='100%'><tr  style='width:100%;font-size:26px;text-align:center;font-weight:700;'><td><img src='".school_logo."' width='70px' style='padding:0px;float:left;' /><span>".school_full_name."</span></td></tr><tr style='width:100%;font-size:16px;text-align:center;font-weight:500;'><td>".school_address."</td></tr></table></div>";
        $html_content.='<h2  style="width:100%;font-size:20px;text-align:center;font-weight:600; "><u>SCHOOL TRANSFER CERTIFICATE</u></h2>';
        $html_content.='<div class="table-responsive"><table class="table table-bordered table-striped"><tbody>';

        $data_student=$this->StudentModel->get_leaving_certificate($id);
        if($data_student){

            foreach($data_student as $student){
                $cdate =date('d-M-Y');
                $table_fee='student_fee';    
                $fee_data=$this->FeeModel->get_single_student_fee_data1($id,$table_fee);    
                $fee_date='';
                if($fee_data){
                    foreach($fee_data as $fee)
                        $fee_date=$fee['fee_date'];
                }
        
                    $html_content .='<tr><td><b>1.  Name of Pupil :<b></td><td style="text-transform: uppercase;"><b>'.$student["student_name"].'<b></td></tr>';
                    $html_content .='<tr><td><b>2.  Father/Guardian Name :<b></td><td style="text-transform: uppercase;"><b>'.$student["father_name"].'<b></td></tr>';
                    $html_content .='<tr><td><b>3.  Mother Name :<b></td><td style="text-transform: uppercase;"><b>'.$student["mother_name"].'<b></td></tr>';
                    $html_content .='<tr><td><b>4.  Date of Birth :<b></td><td style="text-transform: uppercase;"><b>'.$student["dob"].'<b></td></tr>';
                    $html_content .='<tr><td><b>5.  Date of first admission in the school : <b></td><td style="text-transform: uppercase;"><b>'.$student["admission_date"].'<b></td></tr>';
                    $html_content .='<tr><td><b>6.  Class in which the pupil last studied/is studing : </td><td style="text-transform: uppercase;">'.$student["class"].'</td></tr>';
                    $html_content .='<tr><td><b>7.  Whether qualified for promotion to the higher class : <b></td><td style="text-transform: uppercase;"><b>YES<b></td></tr>';

                    $html_content .='<tr><td><b>8.  Month upto which the (pupil has paid) school dues paid : <b></td><td style="text-transform: uppercase;"><b>'.$fee_date.'<b></td></tr>';
                    $html_content .='<tr><td><b>9.  Attendance : <b></td><td ><b>In Session '.$student["y1"].'-'.$student["y2"].'<b></td></tr>';
                    $html_content.='<tr><td><b>10.  Nationality<b></td><td><b>INDIAN<b></td></tr>';
                    $html_content.='<tr><td><b>11.  Withdrawl Date<b></td><td><b>'.$cdate.'<b></td></tr>';
                    $html_content.='<tr><td><b>12.  Date of issue of certificate Date<b></td><td><b>'.$cdate.'<b></td></tr>';



            }
        }else{
   
        }    
    

        $html_content .="</tbody></table></div>";
        // $html_content .="<div class='table-responsive'><table class='table table-bordered table-striped' style='width:100%;'><tbody>";

        $html_content .="<p style='padding:10px;width:100%;'><b>He / She bears a good moral character.<b></p>";
        $html_content .="<p style='width:100%;padding:10px;'>Certified that the above particulars of the students are correct according to the school record.</p>";
        $html_content .="<p style='width:100%;padding:10px;'>All above entries are checked & verified.</p>";
 
        // $html_content .="<tr><td><td></tr>";
  
        // $html_content .="</tbody></table></div>";

        $html_content .="<div class='table-responsive'><table class='table table-bordered table-striped'><tbody>";
        $html_content .="<tr><td style='padding:40px;'></td><td></td><td></td></tr>";
        $html_content .="<tr><td ><b>Prepared by<b></td><td><b>Checked by<b></td><td><b>Sign of Principle with Official seal<b></td></tr>";
        $html_content .="</tbody></table></div>";
        $html_content .="<p style='text-align:center;padding:20px;'><b>website :".school_website."<b></p>";
        $html_content .="</div></body></html>";
        $this->pdf->loadHtml($html_content);
        $this->pdf->render();
        $this->pdf->stream("".$id.".pdf", array("Attachment"=>0));    
    }



    public function new_tc($id){
        if($this->session->userdata('admin')!=1){
            redirect(base_url().'login/');
        }     
        $datee= date('d-M-Y');
        if($this->uri->segment(3)){
            $id = $this->uri->segment(3);}
            $old_limit = ini_set("memory_limit", "64M");
            $dompdf = new Pdf();
            $dompdf->set_paper('A5', 'landscape'); //landscape , portrait
            $html_content=$this->FeeModel->pdf_header();

            $html_content.="<div style='height:110px;text-align:justify;' >
                <div style='width:20% !imporant;float:left;height:100px;margin:0px;'>
                <img src='".school_logo."' style='width:100%;height:auto;float:left;margin:0px;' /></div>
                <div style='width:80%;float:right;height:100px;margin-left:0px;'>
                    <p style='text-align:center;padding:20px;'>
                        <span style='font-size:22px;font-weight:700;padding:20px;margin:0px;'>".school_full_name."</span><br>
                        <span style='padding:12px;font-size:16px;text-align:center;font-weight:500;margin:0px;'>Unit-II, ".school_address."</span></p>

                </div>
            </div>";


$html_content .="<div style='text-align:center !important; margin-top:05px;border-top:1px solid;padding-top:10px;width:100%;height:40px;' >
<div style='width:33%;float:left;'></div>
<div style='width:34%;float:left;padding:10px;text-align:center;font-size:18px;;border:1px solid;'>TRANSFER CERTIFICATE</div>
<div style='width:33%;float:left;'></div>
</div>";

$html_content.="<div style='width:100%;height:40px;margin-top:30px;'>
<div style='width:50%;float:left;'><b>TC. No. :......./..........<b></div>
<div style='width:50%;float:left;text-align:right;'>
<b>SCHOOL CODE :".school_code."</b>
</div>
</div>";


$data_student=$this->StudentModel->get_leaving_certificate($id);
if($data_student){

foreach($data_student as $student){
$cdate =date('d-M-Y');

$html_content .='<p style="line-height:35px;padding:10px;word-spacing:3px;">This is to certify that   <b>'.$student['student_name'].'</b><br>was admitted into this school on the (date) <b>'.$student['admission_date'].'</b> Standard - <b>'.$student['admission_class'].' some text</b><br>on a transfer certificate from <b>'.$student['previous_school'].'some text</b> and left on the<b> Some text</b> with a <b> GOOD  </b>character.<br> was then studying in the <b>'.$student['class'].'</b> class of the ICSE / ISC stream.<br>The school year being from April '.$student['y1'].' to March '.$student['y2'].'.</p>';

$html_content .="<p style='margin-bottom:0px;padding:10px;word-spacing:3px;'>All sums due to this school on account have been paid, remitted or satisfactorily arranged for.</p>";
$html_content.="<p style='line-height:35px;margin-top:0px;padding:10px;word-spacing:3px;'>According to our Admission Register Admission Number is <b>".$student['sch_no']."</b><br> and Date of Birth (in figures) <b>".date('d-m-Y',strtotime($student['dob']))."</b><br>(in words) ".date('d-M-Y',strtotime($student['dob']))." </p>";

$html_content.="<p style='line-height:35px;margin-top:0px;padding:10px;word-spacing:3px;'>(The following additional information must be supplied if the scholar left at the end of the school year)</p>";
$html_content.="<p style='line-height:35px;margin-top:0px;padding:10px;word-spacing:3px;'>Promotion has been <b>Some text.</b></p>";

$html_content.="<div style='margin-top:50px;padding:10px;' >
<div style='width:50%;float:left;text-align:left;'>Date : <b>".$cdate."</b></div>
<div style='width:50%;float:right;text-align:left;'>Sig. Principal : ...................</div>
</div>";
}
}else{
    
}    
    


$html_content .="</body></html>";
$this->pdf->loadHtml($html_content);
$this->pdf->render();
$this->pdf->stream("".$id.".pdf", array("Attachment"=>0));    
}



public function student_certificate($id){
// if($this->session->userdata('admin')!=1){
// redirect(base_url().'login/');
// }     
$datee= date('y-m-d');
if($this->uri->segment(3))
{
$id = $this->uri->segment(3);}
  
$old_limit = ini_set("memory_limit", "64M");
$dompdf = new Pdf();
        
$dompdf->set_paper('A4', 'portrait'); //landscape , portrait
$html_content=$this->FeeModel->pdf_header();
// background-color:#fcb19f;
$html_content .='<div class="col-sm-12" style="border:1px solid;padding-top:20px;">';
$html_content .= '<div class="table-responsive ">';
$html_content .="<table class='table-striped table-bordered' width='100%'>
<tr  style='width:100%;font-size:26px;text-align:center;font-weight:700;'><td><img src='".school_logo."' width='100px' height='70px'style='padding:0px;float:left;' /><span>".school_full_name."</span></td></tr>
<tr style='width:100%;font-size:16px;text-align:center;font-weight:500; border-bottom:1px solid;'><td>".school_address."</td></tr>

</table></div>";

$data_student=$this->StudentModel->get_leaving_certificate($id);
if($data_student){

foreach($data_student as $student){
    $cdate =date('Y-M-D');
$html_content.='<div  style="float:left;width:50%;">';    
$html_content.='<p  style="font-size:20px;text-align:left;font-weight:600;padding:20px;"><u><span style=""><b><u>Adm. No. <u><b><span style="">'.$student['sch_no'].'</span></u></p></div>';
$html_content.='<div  style="float:left;width:50%;">';    
$html_content.='<p style="padding:20px;font-size:20px;text-align:right;font-weight:600;"><u><b>Dated.'.$datee.'<b></u></p></div>';



// $html_content.="<div>";

$html_content.="<p style='text-align:left; font-size:16px;word-spacing:6px;'>
<b>This is to Certified that<u> <span style='text-transform:uppercase;'>".$student['student_name']."</span></u></b></p>";

$html_content.="<p style='text-align:left;  font-size:16px;word-spacing:6px;'><b>S/D of Sh. <span style='text-transform:uppercase;'><u>".$student['father_name']."</u></span></b></p>";

$html_content.="<p style=' font-size:16px;word-spacing:6px;'><b>R/O  <span style='text-transform:uppercase;'><u>".$student['address']."</u></b></p>";

$html_content.="<p style=' font-size:16px;word-spacing:6px;'><b>is a bonafied student of this School w.e.f <u>".$student['admission_date']."</u> to <u>".$datee."</u>.</b></p>";


$html_content .="<p style='font-size:16px;word-spacing:6px;'><b>Now He / She is a student of <u>".$student['class']."-".$student['section']."</u> STD. of this school Since <u>".$datee."</u> .</p>";
$html_content .="<p style='font-size:16px;word-spacing:6px;'><b><b></p>";
$html_content .="<p style='font-size:16px;word-spacing:6px;'><b>His / Her Date of Birth is <u>".$student['dob']."</u>.<b></p>";
$html_content.="<p style='font-size:16px;word-spacing:6px;'><b>as per our school records.<b></p>";

$html_content .="<p style='padding:30px;font-size:18px;text-align:right;margin-top:10px;'><b>(PRINCIPAL)<b></p>";
}
}else{
   
}   

$html_content .="<p style='text-align:center;padding:20px;'><b>website :".school_website."<b></p>";
$html_content .="</div></body></html>";
$this->pdf->loadHtml($html_content);
$this->pdf->render();
$this->pdf->stream("".$id.".pdf", array("Attachment"=>0));
}



    public function my_class_students(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/teachers/my-class-students-asc');
        $this->load->view('erp/footer');
    }


    public function manage_student_profile($id){
        $this->load->view('erp/header');
        // $this->load->view('erp/staff-nav');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/management/manage-student-profile');
        $this->load->view('erp/footer');
    }

    public function documentation($sid){
        $student_profile_picture='';    
        $data['success']=''; $data['error']='';
        if(isset($_POST['student_profile_submit'])){
    
            $sid=$this->input->post('sid');
            $config['file_ext_tolower'] =TRUE;
            $config['encrypt_name'] =TRUE;
            $config['upload_path']= './student-data/profile-img/';
            $config['allowed_types']= 'jpeg|jpg|png';
            $config['max_size']= 5120;
            // $config['max_width']= 1024;
            // $config['max_height']= 768;
            $this->load->library('upload', $config);
            if ( ! $this->upload->do_upload('student_profile_pic')){
                $data['error'] = array('error' => $this->upload->display_errors());
            }else{
                $data1 = array('upload_data' => $this->upload->data());
                foreach($data1 as $img_data){
                    $student_profile_picture=$img_data['file_name'];    
                }
            }

            $table='student_data';
            $field='profile_pic';
            $check_student=$this->StudentModel->check_student_data($sid,$table);
            if($check_student>0){
                $add_student_profile_pic=$this->StudentModel->update_document($sid,$student_profile_picture,$field,$table);   
                if($add_student_profile_pic){
                    $data['success']="Student Profile Added Successfully";
                }else{
                    $data['error']="Error during adding profile";    
                }

            }else{
                $update_student_profile_pic=$this->StudentModel->add_document($sid,$student_profile_picture,$field,$table); 
                if($update_student_profile_pic){
                    $data['success']="Student Profile Updated Successfully";    
                }else{
                    $data['error']="Error during update";
                }

            }
        }

        if(isset($_POST['student_report_card_submit'])){
            $student_report_card='';
            $sid=$this->input->post('sid');
            $config['file_ext_tolower'] =TRUE;
            $config['encrypt_name'] =TRUE;
            $config['upload_path']= './student-data/previous-class-report-card/';
            $config['allowed_types']= 'jpeg|jpg|png';
            $config['max_size']= 5120;
            // $config['max_width']= 1024;
            // $config['max_height']= 768;
            $this->load->library('upload', $config);
            if (!$this->upload->do_upload('student_report_card')){
                $data['error'] = array('error' => $this->upload->display_errors());
            }else{
                $data1 = array('upload_data' => $this->upload->data());
                foreach($data1 as $img_data){
                    $student_report_card=$img_data['file_name'];    
                }
            }

            $table='student_data';
            $field='previous_report_card';
            $check_student=$this->StudentModel->check_student_data($sid,$table);
            if($check_student>0){
                $add_previous_report_card=$this->StudentModel->update_document($sid,$student_report_card,$field,$table);   
                if($add_previous_report_card){
                    $data['success']="Student Report Card Added Successfully";
                }else{
                    $data['error']="Error during adding profile";    
                }

            }else{
                $update_previous_report_card=$this->StudentModel->add_document($sid,$student_report_card,$field,$table); 
                if($update_previous_report_card){
                    $data['success']="Student Report Card Updated Successfully";    
                }else{
                    $data['error']="Error during update";
                }
            }
        }
        if(isset($_POST['student_tc_submit'])){
            $previous_school_tc='';    
            $sid=$this->input->post('sid');
            $config['file_ext_tolower'] =TRUE;
            $config['encrypt_name'] =TRUE;
            $config['upload_path']= './student-data/previous-school-tc/';
            $config['allowed_types']= 'jpeg|jpg|png';
            $config['max_size']= 5120;
            // $config['max_width']= 1024;
            // $config['max_height']= 768;
            $this->load->library('upload', $config);
            if (!$this->upload->do_upload('previous_school_tc')){
                $data['error'] = array('error' => $this->upload->display_errors());
            }else{
                $data1 = array('upload_data' => $this->upload->data());
                foreach($data1 as $img_data){
                    $previous_school_tc=$img_data['file_name'];    
                }
            }

            $table='student_data';
            $field='previous_school_tc';
            $check_student=$this->StudentModel->check_student_data($sid,$table);
            if($check_student>0){
                $add_previous_school_tc=$this->StudentModel->update_document($sid,$previous_school_tc,$field,$table);   
                if($add_previous_school_tc){
                    $data['success']="Student TC Added Successfully";
                }else{
                    $data['error']="Error during adding profile";    
                }
            }else{
                $update_previous_school_tc=$this->StudentModel->add_document($sid,$previous_school_tc,$field,$table); 
                if($update_previous_school_tc){
                    $data['success']="Student TC Updated Successfully";    
                }else{
                    $data['error']="Error during update";
                }
            }
        }

        if(isset($_POST['birth_certificate_submit'])){
            $student_birth_certificate='';
            $sid=$this->input->post('sid');
            $config['file_ext_tolower'] =TRUE;
            $config['encrypt_name'] =TRUE;
            $config['upload_path']= './student-data/birth-certificate/';
            $config['allowed_types']= 'jpeg|jpg|png';
            $config['max_size']= 5120;
            // $config['max_width']= 1024;
            // $config['max_height']= 768;
            $this->load->library('upload', $config);
            if ( ! $this->upload->do_upload('student_birth_certificate')){
                $data['error'] = array('error' => $this->upload->display_errors());
            }else{
                $data1 = array('upload_data' => $this->upload->data());
                foreach($data1 as $img_data){
                    $student_birth_certificate=$img_data['file_name'];    
                }
            }

            $table='student_data';
            $field='birth_certificate';
            $check_student=$this->StudentModel->check_student_data($sid,$table);
            if($check_student>0){
                $add_student_birth_certificate=$this->StudentModel->update_document($sid,$student_birth_certificate,$field,$table);   
                if($add_student_birth_certificate){
                    $data['success']="Student Birth Certificate Added Successfully";
                }else{
                    $data['error']="Error during adding birth certificate";    
                }

            }else{
                $update_student_birth_certificate=$this->StudentModel->add_document($sid,$student_birth_certificate,$field,$table); 
                if($update_student_birth_certificate){
                    $data['success']="Student Birth Certificate Updated Successfully";    
                }else{
                    $data['error']="Error during update";
                }
            }
        }


        if(isset($_POST['registration_form_front_submit'])){
            $registration_form_front='';
            $sid=$this->input->post('sid');
            $config['file_ext_tolower'] =TRUE;
            $config['encrypt_name'] =TRUE;
            $config['upload_path']= './student-data/application-form-front-back/';
            $config['allowed_types']= 'jpeg|jpg|png';
            $config['max_size']= 5120;
            // $config['max_width']= 1024;
            // $config['max_height']= 768;
            $this->load->library('upload', $config);
            if ( ! $this->upload->do_upload('registration_form_front')){
                $data['error'] = array('error' => $this->upload->display_errors());
            }else{
                $data1 = array('upload_data' => $this->upload->data());
                foreach($data1 as $img_data){
                    $registration_form_front=$img_data['file_name'];    
                }
            }

            $table='student_data';
            $field='registration_form_front';
            $check_student=$this->StudentModel->check_student_data($sid,$table);
            if($check_student>0){
                $add_registration_form_front=$this->StudentModel->update_document($sid,$registration_form_front,$field,$table);   
                if($add_registration_form_front){
                    $data['success']="Student Registration Form Front Added Successfully";
                }else{
                    $data['error']="Error during adding registration form front";    
                }

            }else{
                $update_registration_form_front=$this->StudentModel->add_document($sid,$registration_form_front,$field,$table); 
                if($update_registration_form_front){
                    $data['success']="Student Registration Form Front Updated Successfully";    
                }else{
                    $data['error']="Error during update";
                }

            }
        }


        if(isset($_POST['registration_form_back_submit'])){
            $registration_form_back='';
            $sid=$this->input->post('sid');
            $config['file_ext_tolower'] =TRUE;
            $config['encrypt_name'] =TRUE;
            $config['upload_path']= './student-data/application-form-front-back/';
            $config['allowed_types']= 'jpeg|jpg|png';
            $config['max_size']= 5120;
            // $config['max_width']= 1024;
            // $config['max_height']= 768;
            $this->load->library('upload', $config);
            if (!$this->upload->do_upload('registration_form_back')){
                $data['error'] = array('error' => $this->upload->display_errors());
            }else{
                $data1 = array('upload_data' => $this->upload->data());
                foreach($data1 as $img_data){
                    $registration_form_back=$img_data['file_name'];    
                }
            }

            $table='student_data';
            $field='registration_form_back';
            $check_student=$this->StudentModel->check_student_data($sid,$table);
            if($check_student>0){
                $add_registration_form_back=$this->StudentModel->update_document($sid,$registration_form_back,$field,$table);   
                if($add_registration_form_back){
                    $data['success']="Student Registration Form Back Added Successfully.";
                }else{
                    $data['error']="Error during adding registration form back.";    
                }

            }else{
                $update_registration_form_back=$this->StudentModel->add_document($sid,$registration_form_back,$field,$table); 
                if($update_registration_form_back){
                    $data['success']="Student Registration Form Back Updated Successfully";    
                }else{
                    $data['error']="Error during update";
                }

            }
        }

        if(isset($_POST['mothers_profile_pic_submit'])){
            $mothers_profile_pic='';
            $sid=$this->input->post('sid');
            $config['file_ext_tolower'] =TRUE;
            $config['encrypt_name'] =TRUE;
            $config['upload_path']= './student-data/mothers-profile-pics/';
            $config['allowed_types']= 'jpeg|jpg|png';
            $config['max_size']= 5120;
            // $config['max_width']= 1024;
            // $config['max_height']= 768;
            $this->load->library('upload', $config);
            if ( ! $this->upload->do_upload('mothers_profile_pic')){
                $data['error'] = array('error' => $this->upload->display_errors());
            }else{
                $data1 = array('upload_data' => $this->upload->data());
                foreach($data1 as $img_data){
                    $mothers_profile_pic=$img_data['file_name'];    
                }
            }
    
            $table='student_data';
            $field='mothers_profile_pic';
            $check_student=$this->StudentModel->check_student_data($sid,$table);
            if($check_student>0){
                $add_mothers_profile_pic=$this->StudentModel->update_document($sid,$mothers_profile_pic,$field,$table);   
                if($add_mothers_profile_pic){
                    $data['success']="Mother's Profile Picture Added Successfully.";
                }else{
                    $data['error']="Error during adding mother's profile picture.";    
                }

            }else{
                $update_mothers_profile_pic=$this->StudentModel->add_document($sid,$mothers_profile_pic,$field,$table); 
                if($update_mothers_profile_pic){
                    $data['success']="Mother's Profile Picture Updated Successfully";    
                }else{
                    $data['error']="Error during update";
                }

            }
        }
    
        if(isset($_POST['fathers_profile_pic_submit'])){
            $fathers_profile_pic='';
            $sid=$this->input->post('sid');
            $config['file_ext_tolower'] =TRUE;
            $config['encrypt_name'] =TRUE;
            $config['upload_path']= './student-data/fathers-profile-pics/';
            $config['allowed_types']= 'jpeg|jpg|png';
            $config['max_size']= 5120;
            // $config['max_width']= 1024;
            // $config['max_height']= 768;
            $this->load->library('upload', $config);
            if ( ! $this->upload->do_upload('fathers_profile_pic')){
                $data['error'] = array('error' => $this->upload->display_errors());
            }else{
                $data1 = array('upload_data' => $this->upload->data());
                foreach($data1 as $img_data){
                    $fathers_profile_pic=$img_data['file_name'];    
                }
            }

            $table='student_data';
            $field='fathers_profile_pic';
            $check_student=$this->StudentModel->check_student_data($sid,$table);
            if($check_student>0){
                $add_fathers_profile_pic=$this->StudentModel->update_document($sid,$fathers_profile_pic,$field,$table);   
                if($add_fathers_profile_pic){
                    $data['success']="Father's Profile Picture Added Successfully.";
                }else{
                    $data['error']="Error during adding father's profile picture.";    
                }

            }else{
                $update_fathers_profile_pic=$this->StudentModel->add_document($sid,$fathers_profile_pic,$field,$table); 
                if($update_mothers_profile_pic){
                    $data['success']="Father's Profile Picture Updated Successfully";    
                }else{
                    $data['error']="Error during update";
                }
            }
        }

        $this->load->view('erp/header');
        // $this->load->view('erp/staff-nav');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/students/profile-and-documentations',$data);
        $this->load->view('erp/footer');    
    }

    public function change_section(){
        $class='UKG';
        $change=$this->SchoolModel->change_section($class);
        if($change){
            echo $change;    
        }else{
            echo "Something wrong";    
        }
    }

    public function view_student(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/students/view-student');
        $this->load->view('erp/footer');    
    }
        
    public function view_student_pdf(){
        $hello='PG';
        $this->load->view('erp/students/view-student-pdf');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
       
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$hello", array("Attachment"=>0));
    }
       
    public function fee_receipt($fee_no){
        // $hello='PG';
        $this->load->view('erp/new-fee/fee-receipt-pdf');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A5','landscape');
        // Render the HTML as PDF
        $this->pdf->render();
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$fee_no",array("Attachment"=>0));
    }
}