<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Report extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        // $this->load->model('NewFeeModel');
        // $this->load->model('WelcomeModel');
        $this->load->model('NewExamModel');
        // $this->load->model('InvoiceModel');
        $this->load->model('ReportCardModel');
        $this->load->helper('date');
        $this->load->database();
        $this->load->library('form_validation');
        $this->load->helper(array('form', 'url'));
        $this->load->library('session');
        $this->load->library('Pdf');
    }
    
    
    public function index(){
        
    }
    
    public function course_11_commerce_card($id){
        $this->load->view('erp/report-card/commerce-11.php');
        // Get output html
        $html = $this->output->get_output();
        
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('Letter', 'landscape');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$id", array("Attachment"=>0));
    }
    
    public function course_11_commerce($id){
        $this->load->view('erp/report-card/commerce-11-report-card');
        // Get output html
        $html = $this->output->get_output();
        
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'landscape');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$id", array("Attachment"=>0));
    }
    
    
    public function course_wise_report_card($id){
        $this->load->view('erp/report-card/report-card');
        // Get output html
        $html = $this->output->get_output();
        
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // $this->pdf->setPaper('A4', 'landscape');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$id", array("Attachment"=>0));
    }
    
    
    public function report_card($id){
        $data['id']=$id;
        // $this->load->view('erp/report-card/new-landscape-report-card',true);
        $this->load->view('erp/report-card/new-landscape-report-card-1',true);
        // Get output html
        $html = $this->output->get_output();
        // $this->pdf->set_option( 'isJavascriptEnabled' , true );
        // Load HTML content
        $this->pdf->loadHtml($html);
        
        $this->pdf->set_option('enable-javascript', true);
        $this->pdf->set_option('images', true);
        $this->pdf->set_option('javascript-delay', 13000); // page load is quick but even a high number doesn't help
        $this->pdf->set_option('enable-smart-shrinking', true);
        $this->pdf->set_option('no-stop-slow-scripts', true);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        // $this->pdf->setPaper('A4', 'portrait');
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$id", array("Attachment"=>0));
    }
    
    public function report_Card11($id){
        // $this->load->view('erp/report-card/new-landscape-report-card');
        
        $data['id']=$id;
        $this->load->view('erp/report-card/new-landscape-report-card-1',true);
        // Get output html
        $html = $this->output->get_output();
        // $this->pdf->set_option( 'isJavascriptEnabled' , true );
        // Load HTML content
        $this->pdf->loadHtml($html);
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        // $this->pdf->setPaper('A4', 'portrait');
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$id", array("Attachment"=>0));
    }
    
    public function fetch_data(){
        $x_values = array(1,2,3,4,5,6,7,8,9,10);
        $y_values = array(500,1000,750,1200,1300,650,870,400,800,1100);

        $columns = count($x_values);
        $width = 600;
        $height = 400;


        $margin = 20;
        $padding = 10;
        $column_width = ($width-$margin*2) / $columns ;


        $im = imagecreate($width,$height);

        $white = imagecolorallocate ($im,0xff,0xff,0xff);
        $black = imagecolorallocate ($im,0x00,0x00,0x00);
        $red = imagecolorallocate ($im,0xff,0x00,0x00);
        $blue = imagecolorallocate ($im,0x00,0x33,0xff);
        $gray = imagecolorallocate ($im,0xcc,0xcc,0xcc);


        imagefilledrectangle($im,0,0,$width,$height,$white);

        $maxv = 0;
        for($i=0;$i<$columns;$i++)$maxv = max($y_values[$i],$maxv);

        imageline($im,$margin*3-10,$height-$margin*2,$width-$margin+$padding,$height-$margin*2,$gray);
        for($i=0;$i<$columns;$i++){
            $column_height = $height * ( $y_values[$i] / $maxv) ;
            imageline($im,$margin*3-10,$height-$column_height+$margin*2,$width-$margin+$padding,$height-$column_height+$margin*2,$gray);
        }

        for($i=0;$i<$columns;$i++){
            $column_height = $height * ( $y_values[$i] / $maxv) ;
            $x1 = $i*$column_width + $margin*3 ;
            $y1 = $height-$column_height+$margin*2;
            $x2 = (($i+1)*$column_width)-$padding +$margin*2;
            $y2 = $height-$margin*2;
            imagefilledrectangle($im,$x1,$y1,$x2,$y2,$blue); // Bar color
            ImageString($im,5,$x1,$y2+10,$x_values[$i],$black); // X labels
            ImageString($im,5,10,$y1-10,round($y_values[$i],0),$black); // Y labels
        }
        ImageString($im,5,$width-$margin*2,$y2+25,'Year',$red); // X title
        ImageString($im,5,10,10,'Profit',$red); // Y title

        header("Content-type:image/png");
        imagepng($im);

        // or you can save the chart

        imagepng($im,'graph.png');

        // clear up memory

        imagedestroy($im);
    }
    public function barchart(){
        $this->load->view('erp/report-card/barchart');
    }
    public function report_card_without_head($id){
        // without-header-report-card-portrait.php
        // $this->load->view('erp/report-card/new-landscape-report-card');
        
        $this->load->view('erp/report-card/without-header-report-card-portrait');
        // Get output html
        $html = $this->output->get_output();
        
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        // $this->pdf->setPaper('A4', 'portrait');
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$id", array("Attachment"=>0));
    }
    
    
    public function course_report_card($id,$section,$class){
        $data['id']=$id;
        $courses_table="courses";
        $course="";
        // $get_course_data=$this->NewExamModel->get_item_data($id,$courses_table);
        // if($get_course_data){
        //     foreach($get_course_data as $course_data){
        //         $course=$course_data["course"]."-".$section."-Half-Yearly-Report-Cards";        
        //     }
        // }
        // $this->load->view('erp/report-card/new-landscape-report-card',true);
        
        
        $course=$class."-".$section."-Half-Yearly-Report-Cards";        
        if($id >11){
            $this->load->view('erp/report-card/course-portrait-report-card',true);
        }else{
            $this->load->view('erp/report-card/course-report-card-1',true);
        }
        
        // Get output html
        $html = $this->output->get_output();
        // $this->pdf->set_option( 'isJavascriptEnabled' , true );
        // Load HTML content
        $this->pdf->loadHtml($html);
        
        $this->pdf->set_option('enable-javascript', true);
        $this->pdf->set_option('images', true);
        $this->pdf->set_option('javascript-delay', 13000); // page load is quick but even a high number doesn't help
        $this->pdf->set_option('enable-smart-shrinking', true);
        $this->pdf->set_option('no-stop-slow-scripts', true);
    
        $old_limit = ini_set("memory_limit", "51200M");
        // (Optional) Setup the paper size and orientation
        // $this->pdf->setPaper('A4', 'portrait');
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$course", array("Attachment"=>0));
    }
    
    public function course_report_card_1($id,$section){
        // sjec.pinakatechnology.in/application/views/erp/report-card/course-report-card-1.php
        $data['id']=$id;
        $courses_table="courses";
        $course="";
        $get_course_data=$this->NewExamModel->get_item_data($id,$courses_table);
        if($get_course_data){
            foreach($get_course_data as $course_data){
                $course=$course_data["course"]."-".$section."-Half-Yearly-Report-Cards";        
            }
        }
        // $this->load->view('erp/report-card/new-landscape-report-card',true);
        $this->load->view('erp/report-card/course-report-card-1',true);
        // Get output html
        $html = $this->output->get_output();
        // $this->pdf->set_option( 'isJavascriptEnabled' , true );
        // Load HTML content
        $this->pdf->loadHtml($html);
        
        $this->pdf->set_option('enable-javascript', true);
        $this->pdf->set_option('images', true);
        $this->pdf->set_option('javascript-delay', 13000); // page load is quick but even a high number doesn't help
        $this->pdf->set_option('enable-smart-shrinking', true);
        $this->pdf->set_option('no-stop-slow-scripts', true);
    
        $old_limit = ini_set("memory_limit", "51200M");
        // (Optional) Setup the paper size and orientation
        // $this->pdf->setPaper('A4', 'portrait');
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$course", array("Attachment"=>0));
    }
    
    public function course_report_card_final($class,$section){
        $course=$class."-".$section."-Half-Yearly-Report-Cards";
        
        // $this->load->view('erp/report-card/new-landscape-report-card',true);
        if($class == 9 || $class== 10 || $class == 11 || $class==12){
            $this->load->view('erp/report-card/course-report-card-final-hsc',true);    
        }else if($class == 6 || $class == 7 || $class == 8){
            $this->load->view('erp/report-card/course-report-card-final-6-8',true);
        }else if($class == 1 || $class == 2  || $class == 3 || $class == 4 || $class == 5 || $class == "PG" || $class == "LKG" || $class == "UKG"){
            $this->load->view('erp/report-card/class-1-5-report-card',true);
        }
        
        
        
        // Get output html
        $html = $this->output->get_output();
        // $this->pdf->set_option( 'isJavascriptEnabled' , true );
        // Load HTML content
        $this->pdf->loadHtml($html);
        
        $this->pdf->set_option('enable-javascript', true);
        $this->pdf->set_option('images', true);
        $this->pdf->set_option('javascript-delay', 13000); // page load is quick but even a high number doesn't help
        $this->pdf->set_option('enable-smart-shrinking', true);
        $this->pdf->set_option('no-stop-slow-scripts', true);
    
        $old_limit = ini_set("memory_limit", "51200M");
        // (Optional) Setup the paper size and orientation
        // $this->pdf->setPaper('A4', 'portrait');
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$course", array("Attachment"=>0));
    }
    
    
    public function second_term_report_card_final($class,$section){
        $course=$class."-".$section."-Half-Yearly-Report-Cards";
        
        // $this->load->view('erp/report-card/new-landscape-report-card',true);
        if($class == 9 || $class== 10 || $class == 11 || $class==12){
            // $this->load->view('erp/report-card/second-term-report-card-final-hsc',true);    
            $this->load->view('erp/report-card/second-term-report-card-hsc',true);    
            
        }else if($class == 6 || $class == 7 || $class == 8){
            // $this->load->view('erp/report-card/second-term-report-card-final-6-8',true);
            $this->load->view('erp/report-card/second-term-class-6-8-report-card',true);
        }else if($class == 1 || $class == 2  || $class == 3 || $class == 4 || $class == 5 || $class == "PG" || $class == "LKG" || $class == "UKG"){
            $this->load->view('erp/report-card/second-term-class-1-5-report-card',true);
        }
        
        
        
        // Get output html
        $html = $this->output->get_output();
        // $this->pdf->set_option( 'isJavascriptEnabled' , true );
        // Load HTML content
        $this->pdf->loadHtml($html);
        
        $this->pdf->set_option('enable-javascript', true);
        $this->pdf->set_option('images', true);
        $this->pdf->set_option('javascript-delay', 13000); // page load is quick but even a high number doesn't help
        $this->pdf->set_option('enable-smart-shrinking', true);
        $this->pdf->set_option('no-stop-slow-scripts', true);
    
        $old_limit = ini_set("memory_limit", "51200M");
        // (Optional) Setup the paper size and orientation
        // $this->pdf->setPaper('A4', 'portrait');
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$course", array("Attachment"=>0));
    }
    
    public function annual_report_card_1($id){
        $this->load->view('erp/report-card/annual-report-card-portrait-without-header-1');
        // Get output html
        $html = $this->output->get_output();
        
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        // $this->pdf->setPaper('A4', 'portrait');
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$id", array("Attachment"=>0));
    }
    
    public function annual_report_card($id){
        $this->load->view('erp/report-card/annual-report-card-portrait-without-header');
        // Get output html
        $html = $this->output->get_output();
        
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        // $this->pdf->setPaper('A4', 'portrait');
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$id", array("Attachment"=>0));
    }
    
    
    public function annual_report_card_new($id){
        $this->load->view('erp/report-card/new/annual-report-card-landscape-new');
        // Get output html
        $html = $this->output->get_output();
        
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // $this->pdf->setPaper('A4', 'landscape');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$id", array("Attachment"=>0));
    }
    
    public function annual_report_card_final($class,$section){
        $course=$class."-".$section."-Annual-Report-Cards";
        
        // $this->load->view('erp/report-card/new-landscape-report-card',true);
        if($class == 11 ){
            $this->load->view('erp/report-card/annual_report_card/annual-report-card-class-11-and-12',true);
        }else if($class == 9 ){
            // $this->load->view('erp/report-card/second-term-report-card-final-hsc',true);    
            // $this->load->view('erp/report-card/annual_report_card/annual-report-card-hsc',true);
            // $this->load->view('erp/report-card/annual_report_card/annual-report-card-new',true);
            $this->load->view('erp/report-card/annual_report_card/class-9-report-card-new',true);
            
            
        }else if($class == 6 || $class == 7 || $class == 8){
            // $this->load->view('erp/report-card/second-term-report-card-final-6-8',true);
            // $this->load->view('erp/report-card/annual_report_card/annual-class-6-8-report-card',true);
            // $this->load->view('erp/report-card/annual_report_card/annual-report-card-6-to-8-landscape',true);
            // $this->load->view('erp/report-card/annual_report_card/annual-report-card-6-to-8-portrait',true);
            $this->load->view('erp/report-card/annual_report_card/annual-report-card-6-to-8-portrait-new',true);
        }else if($class == 1 || $class == 2  || $class == 3 || $class == 4 || $class == 5 || $class == "PG" || $class == "LKG" || $class == "UKG"){
            // $this->load->view('erp/report-card/annual_report_card/annual-class-1-5-report-card',true);
            // $this->load->view('erp/report-card/annual_report_card/annual-report-card-new',true);
            // $this->load->view('erp/report-card/annual_report_card/annual-report-card-6-to-8-portrait',true);
            // $this->load->view('erp/report-card/annual_report_card/annual-report-card-6-to-8-portrait-new',true);
            
            $this->load->view('erp/report-card/annual_report_card/class-1-to-5-portrait-report-card-new',true);
        }
        // else if(){
        //     $this->load->view('class-1-to-5-portrait-report-card-new');
        // }
        
        
        
        // Get output html
        $html = $this->output->get_output();
        // $this->pdf->set_option( 'isJavascriptEnabled' , true );
        // Load HTML content
        $this->pdf->loadHtml($html);
        
        $this->pdf->set_option('enable-javascript', true);
        $this->pdf->set_option('images', true);
        $this->pdf->set_option('javascript-delay', 13000); // page load is quick but even a high number doesn't help
        $this->pdf->set_option('enable-smart-shrinking', true);
        $this->pdf->set_option('no-stop-slow-scripts', true);
    
        $old_limit = ini_set("memory_limit", "51200M");
        // (Optional) Setup the paper size and orientation
        // $this->pdf->setPaper('A4', 'portrait');
        if($class == 11 ){
            $this->pdf->setPaper('A4', 'portrait');
        }else if($class == 9 ){
            $this->pdf->setPaper('A4', 'portrait');
        }else{
            // $this->pdf->setPaper('A4', 'landscape');
            $this->pdf->setPaper('A4', 'portrait');
        }
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$course", array("Attachment"=>0));
    }
    
    
    public function annual_report_card_final_new($class,$section){
        $course=$class."-".$section."-Annual-Report-Cards";
        $this->load->view('erp/report-card/annual_report_card/annual-report-card-6-to-8-portrait-new',true);
        // Get output html
        $html = $this->output->get_output();
        
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "51200M");
        // (Optional) Setup the paper size and orientation
        // $this->pdf->setPaper('A4', 'portrait');
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$course", array("Attachment"=>0));
    }
    
}