<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ledger extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('NewFeeModel');
        $this->load->model('WelcomeModel');
        $this->load->model('OpeningBalanceModel');
        $this->load->model('InvoiceModel');
        $this->load->model('LedgerModel');
        $this->load->helper('date');
        $this->load->database();
        $this->load->library('form_validation');
        $this->load->helper(array('form', 'url'));
        $this->load->library('session');
        $this->load->library('Pdf');
    }

    public function student_ledger($sid){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/ledger/ledger');
        $this->load->view('erp/footer');
    }
    public function student_ledger_1($sid){
                $course_id='';
                $acedemic_session=$this->session->userdata('acedemic_session');
                $student_course_info=$this->LedgerModel->student_course_info($sid,$acedemic_session);
                if($student_course_info){
                    foreach($student_course_info as $course_info){
                        $course_id=$course_info['course_id'];
                    }
                }
        
                $y1=$this->session->userdata('y1');
                $y2=$this->session->userdata('y2');
                $tid=$this->session->userdata('tid');
                $cat=date('Y-m-d H:i:s');
        
                $prev_acedemic_session=$acedemic_session - 1;
                $get_opening_balance=$this->NewFeeModel->get_students_opening_fee($sid,$prev_acedemic_session);
                // $ledger_table='student_ledger_'.$acedemic_session.'';
                $ledger_table='student_ledger';
                if($get_opening_balance){
                    foreach($get_opening_balance as $opening_balance){
                        $opening_fee_amount=$opening_balance['opening_fee_amount']; 
                        $check_opening_balance_exist=$this->LedgerModel->check_opening_balance_exist($sid,$acedemic_session,$ledger_table);
                        if($check_opening_balance_exist){
                    
                        }else{
                            $opening_balance_dr_date=''.$y1.'-04-01';
                            $opening_balance_array=array("particulars"=>"Opening Balance","acedemic_session"=>$acedemic_session,"fee_type"=>"opening_balance","trans_type"=>"dr","sid"=>$sid,"debit"=>$opening_fee_amount,"date"=>$opening_balance_dr_date,"cat"=>$cat,"cat_by"=>$tid,"day"=>01,"month"=>04,"year"=>$y1);
                            $add_opening_balance=$this->LedgerModel->insert_data($opening_balance_array,$ledger_table);
                        }
                    }
                    $get_opening_fee_invoices=$this->LedgerModel->get_opening_balance_fee($sid,$acedemic_session);
                    if($get_opening_fee_invoices){
                        foreach($get_opening_fee_invoices as $opening_fee_invoices){
                            $opening_fee_invoice_no=$opening_fee_invoices['id'];
                            $opening_fee_type='opening_balance';
                            $check_opening_balance_fee_exist=$this->LedgerModel->fee_invoice_exist($sid,$opening_fee_type,$opening_fee_invoice_no,$ledger_table);
                            if($check_opening_balance_fee_exist){
                        
                            }else{
                        
                                $opening_fee_inv_rec_amount=$opening_fee_invoices['received_amount'];
                                $opening_balance_cr_fee_date=$opening_fee_invoices['fee_date'];
                                $day=date('d',strtotime($opening_fee_invoices['fee_date']));
                                $month=date('m',strtotime($opening_fee_invoices['fee_date']));
                                $year=date('Y',strtotime($opening_fee_invoices['fee_date']));
                                $opening_balance_fee_array=array("particulars"=>"Opening Balance","acedemic_session"=>$acedemic_session,"fee_type"=>$opening_fee_type,"inv_no"=>$opening_fee_invoice_no,"trans_type"=>"cr","sid"=>$sid,"credit"=>$opening_fee_inv_rec_amount,"balance"=>$opening_fee_invoices['balance_amount'],"date"=>$opening_balance_cr_fee_date,"cat"=>$cat,"cat_by"=>$tid,"day"=>$day,"month"=>$month,"year"=>$year);
                                $add_opening_balance_fee=$this->LedgerModel->insert_data($opening_balance_fee_array,$ledger_table);
                        
                            }
                        }
                    }
                }
        
                $todate=date('Y-m-d');
        
                $curr_month=date('m',strtotime($todate));
                $curr_year=date('Y',strtotime($todate));
                if($curr_year == $y1){
                    for($m= 4;$m <=$curr_month ;$m++){
                        $dd=1;
                        $month_name='';
                        $date_new=''.$y1.'-'.$m.'-'.$dd.'';
                        $dr_date= date('Y-m-d',strtotime($date_new));
                        $get_course_month_fee=$this->LedgerModel->fee_structure($course_id,$acedemic_session);
                        $month_fee=0;
                        if($m ==4){
                            $month_name='april';
                            
                        }else if($m == 5){
                            $month_name='may';
                        }else if($m == 6){
                            $month_name='june';
                        }else if($m == 7){
                            $month_name='july';
                        }else if($m == 8){
                            $month_name='august';
                        }else if($m == 9){
                            $month_name='september';
                        }else if($m == 10){
                            $month_name='october';
                        }else if($m ==11){
                            $month_name='november';
                        }else if($m == 12){
                            $month_name='december';
                        }
                
                
                        if($get_course_month_fee){
                            foreach($get_course_month_fee as $course_month_fee){
                                if($course_month_fee[$month_name] == 1){
                                    $month_fee=$month_fee + $course_month_fee['amount'];
                                }
                            }
                        }
                        $monthly_fee_type='monthly_fee';
                        $check_fee_dr_added=$this->LedgerModel->check_monthly_fee_debit_info($month_name,$sid,$acedemic_session,$monthly_fee_type,$dr_date,$ledger_table);
                        if($check_fee_dr_added){
                    
                        }else{
                            $monthly_fee_dr_array=array(
                                "particulars"=>"Monthly Fee",
                                "acedemic_session"=>$acedemic_session,
                                "fee_type"=>$monthly_fee_type,
                                "trans_type"=>"Dr",
                                "sid"=>$sid,
                                "debit"=>$month_fee,
                                "date"=>$dr_date,
                                "cat"=>$cat,
                                "cat_by"=>$tid,
                                "day"=>01,
                                "month"=>$m,
                                "year"=>$y1,
                                "month_name"=>$month_name
                            );
                            $add_monthly_fee_dr=$this->LedgerModel->insert_data($monthly_fee_dr_array,$ledger_table);
                    
                        }
                    }
                }else if($curr_year == $y2){
                    for($m= 1;$m <=3 ;$m++){
                        $dd=1;
                        $month_name='';
                        $date_new=''.$y1.'-'.$m.'-'.$dd.'';
                        $dr_date= date('Y-m-d',strtotime($date_new));
                        $get_course_month_fee=$this->LedgerModel->fee_structure($course_id,$acedemic_session);
                        $month_fee=0;
                        if($m ==4){$month_name='april';}else if($m == 5){$month_name='may';}else if($m == 6){$month_name='june';}else if($m == 7){$month_name='july';}else if($m == 8){$month_name='august';}else if($m == 9){$month_name='september';}else if($m == 10){$month_name='october';}else if($m ==11){$month_name='november';}else if($m == 12){$month_name='december';}
                
                
                        if($get_course_month_fee){
                            foreach($get_course_month_fee as $course_month_fee){
                                if($course_month_fee[$month_name] == 1){
                                    $month_fee=$month_fee + $course_month_fee['amount'];
                                }
                            }
                        }
                        $monthly_fee_type='monthly_fee';
                        $check_fee_dr_added=$this->LedgerModel->check_monthly_fee_debit_info($month_name,$sid,$acedemic_session,$monthly_fee_type,$dr_date,$ledger_table);
                        if($check_fee_dr_added){
                    
                        }else{
                            $monthly_fee_dr_array=array("particulars"=>"Monthly Fee","acedemic_session"=>$acedemic_session,"fee_type"=>$monthly_fee_type,"trans_type"=>"dr","sid"=>$sid,"debit"=>$month_fee,"date"=>$dr_date,"cat"=>$cat,"cat_by"=>$tid,"day"=>01,"month"=>$m,"year"=>$y1,"month_name"=>$month_name);    
                            $add_monthly_fee_dr=$this->LedgerModel->insert_data($monthly_fee_dr_array,$ledger_table);
                    
                        }
                    }
            
                    for($m= 1;$m <=$curr_month ;$m++){
                        $dd=1;
                        $month_name='';
                        $date_new=''.$y1.'-'.$m.'-'.$dd.'';
                        $dr_date= date('Y-m-d',strtotime($date_new));
                        $get_course_month_fee=$this->LedgerModel->fee_structure($course_id,$acedemic_session);
                        $month_fee=0;
                        if($m ==4){$month_name='april';}else if($m == 5){$month_name='may';}else if($m == 6){$month_name='june';}else if($m == 7){$month_name='july';}else if($m == 8){$month_name='august';}else if($m == 9){$month_name='september';}else if($m == 10){$month_name='october';}else if($m ==11){$month_name='november';}else if($m == 12){$month_name='december';}
                
                
                        if($get_course_month_fee){
                            foreach($get_course_month_fee as $course_month_fee){
                                if($course_month_fee[$month_name] == 1){
                                    $month_fee=$month_fee + $course_month_fee['amount'];
                                }
                            }
                        }
                        $monthly_fee_type='monthly_fee';
                        $check_fee_dr_added=$this->LedgerModel->check_monthly_fee_debit_info($month_name,$sid,$acedemic_session,$monthly_fee_type,$dr_date,$ledger_table);
                        if($check_fee_dr_added){
                    
                        }else{
                            $monthly_fee_dr_array=array("particulars"=>"Monthly Fee","acedemic_session"=>$acedemic_session,"fee_type"=>$monthly_fee_type,"trans_type"=>"dr","sid"=>$sid,"debit"=>$month_fee,"date"=>$dr_date,"cat"=>$cat,"cat_by"=>$tid,"day"=>01,"month"=>$m,"year"=>$y1,"month_name"=>$month_name);    
                            $add_monthly_fee_dr=$this->LedgerModel->insert_data($monthly_fee_dr_array,$ledger_table);
                    
                        }
                    }
                }
        
        
                $get_monthly_fee_invoices=$this->LedgerModel->get_fee_invoices($sid,$acedemic_session);
                if($get_monthly_fee_invoices){
                    foreach($get_monthly_fee_invoices as $monthly_fee_invoices){
                        $monthly_fee_type='monthly_fee';
                        $fee_no=$monthly_fee_invoices['fee_no'];
                        $received_amount=$monthly_fee_invoices['received_amount'];
                        $balance_amount=$monthly_fee_invoices['balance_amount'];
                        $cr_fee_date=$monthly_fee_invoices['fee_date'];
                        $dayy=date('d',strtotime($cr_fee_date));
                        $monthh=date('m',strtotime($cr_fee_date));
                        $yearr=date('Y',strtotime($cr_fee_date));
                        $discount=$monthly_fee_invoices['discount'];
                        $payment_mode=$monthly_fee_invoices['payment_mode'];
                        $check_invoice_exist=$this->LedgerModel->fee_invoice_exist($sid,$monthly_fee_type,$fee_no,$ledger_table);
                        if($check_invoice_exist){
                    
                        }else{
                            $fee_invoice_array=array(
                                "particulars"=>"Monthly Fee",
                                "acedemic_session"=>$acedemic_session,
                                "fee_type"=>$monthly_fee_type,
                                "inv_no"=>$fee_no,
                                "trans_type"=>"Cr",
                                "sid"=>$sid,
                                "credit"=>$received_amount,
                                "payment_mode"=>$payment_mode,
                                "date"=>$cr_fee_date,
                                "cat"=>$cat,
                                "cat_by"=>$tid,
                                "day"=>$dayy,
                                "month"=>$monthh,
                                "year"=>$yearr
                            );
                            $add_fee_invoice=$this->LedgerModel->insert_data($fee_invoice_array,$ledger_table);
                            if($discount > 0){
                                $fee_discount_array=array(
                                    "particulars"=>"Monthly Fee",
                                    "acedemic_session"=>$acedemic_session,
                                    "fee_type"=>$monthly_fee_type,
                                    "inv_no"=>$fee_no,
                                    "trans_type"=>"Cr",
                                    "sid"=>$sid,
                                    "credit"=>$discount,
                                    "payment_mode"=>"Discount",
                                    "date"=>$cr_fee_date,
                                    "cat"=>$cat,
                                    "cat_by"=>$tid,
                                    "day"=>$dayy,
                                    "month"=>$monthh,
                                    "year"=>$yearr
                                );
                                $add_fee_invoice=$this->LedgerModel->insert_data($fee_discount_array,$ledger_table);
                            }
                        }
                
                
                    }
                }
        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/ledger/ledger');
        $this->load->view('erp/footer');
    }
    
    
    public function automation(){
        
        $academic_session_details_table="academic_session_details";
        $acedemic_session="";
        $y1="";
        $y2="";
        $tid=1;
        $get_active_aca_sess_data=$this->LedgerModel->get_active_data($academic_session_details_table);
        if($get_active_aca_sess_data){
            foreach($get_active_aca_sess_data as $academic_session_data){
                $acedemic_session=$academic_session_data['id'];
                $y1=$academic_session_data['y1'];
                $y2=$academic_session_data['y2'];
            }
        }
        // $acedemic_session=$this->session->userdata('acedemic_session');
        // $y1=$this->session->userdata('y1');
        // $y2=$this->session->userdata('y2');
        // $tid=$this->session->userdata('tid');
        
        $get_active_students=$this->LedgerModel->get_active_students($acedemic_session);
        if($get_active_students){
            foreach($get_active_students as $students_data){
                $sid=$students_data['sid'];
                $new_admission=$students_data['new_admission'];
                $course_id=$students_data['course_id'];
                // $course_id='';
                // $student_course_info=$this->LedgerModel->student_course_info($sid,$acedemic_session);
                // if($student_course_info){
                //     foreach($student_course_info as $course_info){
                        
                //     }
                // }
        
                
                $cat=date('Y-m-d H:i:s');
        
                $prev_acedemic_session=$acedemic_session - 1;
                $get_opening_balance=$this->NewFeeModel->get_students_opening_fee($sid,$prev_acedemic_session);
                // $ledger_table='student_ledger_'.$acedemic_session.'';
                $ledger_table='student_ledger';
                // if($get_opening_balance){
                //     foreach($get_opening_balance as $opening_balance){
                //         $opening_fee_amount=$opening_balance['opening_fee_amount']; 
                //         $check_opening_balance_exist=$this->LedgerModel->check_opening_balance_exist($sid,$acedemic_session,$ledger_table);
                //         if($check_opening_balance_exist){
                    
                //         }else{
                //             $opening_balance_dr_date=''.$y1.'-04-01';
                //             $opening_balance_array=array("particulars"=>"Opening Balance","acedemic_session"=>$acedemic_session,"fee_type"=>"opening_balance","trans_type"=>"dr","sid"=>$sid,"debit"=>$opening_fee_amount,"date"=>$opening_balance_dr_date,"cat"=>$cat,"cat_by"=>$tid,"day"=>01,"month"=>04,"year"=>$y1);
                //             $add_opening_balance=$this->LedgerModel->insert_data($opening_balance_array,$ledger_table);
                //         }
                //     }
                //     $get_opening_fee_invoices=$this->LedgerModel->get_opening_balance_fee($sid,$acedemic_session);
                //     if($get_opening_fee_invoices){
                //         foreach($get_opening_fee_invoices as $opening_fee_invoices){
                //             $opening_fee_invoice_no=$opening_fee_invoices['id'];
                //             $opening_fee_type='opening_balance';
                //             $check_opening_balance_fee_exist=$this->LedgerModel->fee_invoice_exist($sid,$opening_fee_type,$opening_fee_invoice_no,$ledger_table);
                //             if($check_opening_balance_fee_exist){
                        
                //             }else{
                        
                //                 $opening_fee_inv_rec_amount=$opening_fee_invoices['received_amount'];
                //                 $opening_balance_cr_fee_date=$opening_fee_invoices['fee_date'];
                //                 $day=date('d',strtotime($opening_fee_invoices['fee_date']));
                //                 $month=date('m',strtotime($opening_fee_invoices['fee_date']));
                //                 $year=date('Y',strtotime($opening_fee_invoices['fee_date']));
                //                 $opening_balance_fee_array=array("particulars"=>"Opening Balance","acedemic_session"=>$acedemic_session,"fee_type"=>$opening_fee_type,"inv_no"=>$opening_fee_invoice_no,"trans_type"=>"cr","sid"=>$sid,"credit"=>$opening_fee_inv_rec_amount,"balance"=>$opening_fee_invoices['balance_amount'],"date"=>$opening_balance_cr_fee_date,"cat"=>$cat,"cat_by"=>$tid,"day"=>$day,"month"=>$month,"year"=>$year);
                //                 $add_opening_balance_fee=$this->LedgerModel->insert_data($opening_balance_fee_array,$ledger_table);
                        
                //             }
                //         }
                //     }
                // }
        
                $todate=date('Y-m-d');
        
                $curr_month=date('m',strtotime($todate));
                $curr_year=date('Y',strtotime($todate));
                if($curr_year == $y1){
                    for($m= 4;$m <=$curr_month ;$m++){
                        $dd=1;
                        $month_name='';
                        $date_new=''.$y1.'-'.$m.'-'.$dd.'';
                        $dr_date= date('Y-m-d',strtotime($date_new));
                        $get_course_month_fee=$this->LedgerModel->monthly_fee_structure($course_id,$acedemic_session);
                        $month_fee=0;
                        if($m ==4){
                            $month_name='april';
                        }else if($m == 5){
                            $month_name='may';
                        }else if($m == 6){
                            $month_name='june';
                        }else if($m == 7){
                            $month_name='july';
                        }else if($m == 8){
                            $month_name='august';
                        }else if($m == 9){
                            $month_name='september';
                        }else if($m == 10){
                            $month_name='october';
                        }else if($m ==11){
                            $month_name='november';
                        }else if($m == 12){
                            $month_name='december';
                        }
                
                
                        if($get_course_month_fee){
                        foreach($get_course_month_fee as $course_month_fee){
                                
                            if($month_name == 'april'){
                            if($course_month_fee[$month_name] == 1){
                                        
                            if($new_admission == "Yes"){
                                $month_fee= $month_fee + $course_month_fee['amount'];    
                            }else{
                                if($course_month_fee['fee_head'] == 2){
                            
                                }else{
                                $month_fee=$month_fee + $course_month_fee['amount'];
                                }
                            }
                                        
                            }
                    
                            }else{
                                
                                if($course_month_fee[$month_name] == 1){
                                    $month_fee=$month_fee + $course_month_fee['amount'];
                                }
                            }
                        }
                        }
                        $monthly_fee_type='monthly_fee';
                        $check_fee_dr_added=$this->LedgerModel->check_monthly_fee_debit_info($month_name,$sid,$acedemic_session,$monthly_fee_type,$dr_date,$ledger_table);
                        if($check_fee_dr_added){
                    
                        }else{
                            $monthly_fee_dr_array=array(
                                "particulars"=>"Monthly Fee",
                                "acedemic_session"=>$acedemic_session,
                                "fee_type"=>$monthly_fee_type,
                                "trans_type"=>"Dr",
                                "sid"=>$sid,
                                "debit"=>$month_fee,
                                "date"=>$dr_date,
                                "cat"=>$cat,
                                "cat_by"=>$tid,
                                "day"=>01,
                                "month"=>$m,
                                "year"=>$y1,
                                "month_name"=>$month_name
                            );
                            $add_monthly_fee_dr=$this->LedgerModel->insert_data($monthly_fee_dr_array,$ledger_table);
                    
                        }
                    }
                }else if($curr_year == $y2){
                    // for($m= 1;$m <=3 ;$m++){
                    //     $dd=1;
                    //     $month_name='';
                    //     $date_new=''.$y1.'-'.$m.'-'.$dd.'';
                    //     $dr_date= date('Y-m-d',strtotime($date_new));
                    //     $get_course_month_fee=$this->LedgerModel->fee_structure($course_id,$acedemic_session);
                    //     $month_fee=0;
                    //     if($m ==4){$month_name='april';}else if($m == 5){$month_name='may';}else if($m == 6){$month_name='june';}else if($m == 7){$month_name='july';}else if($m == 8){$month_name='august';}else if($m == 9){$month_name='september';}else if($m == 10){$month_name='october';}else if($m ==11){$month_name='november';}else if($m == 12){$month_name='december';}
                
                
                    //     if($get_course_month_fee){
                    //         foreach($get_course_month_fee as $course_month_fee){
                    //             if($course_month_fee[$month_name] == 1){
                    //                 $month_fee=$month_fee + $course_month_fee['amount'];
                    //             }
                    //         }
                    //     }
                    //     $monthly_fee_type='monthly_fee';
                    //     $check_fee_dr_added=$this->LedgerModel->check_monthly_fee_debit_info($month_name,$sid,$acedemic_session,$monthly_fee_type,$dr_date,$ledger_table);
                    //     if($check_fee_dr_added){
                    
                    //     }else{
                    //         $monthly_fee_dr_array=array("particulars"=>"Monthly Fee","acedemic_session"=>$acedemic_session,"fee_type"=>$monthly_fee_type,"trans_type"=>"dr","sid"=>$sid,"debit"=>$month_fee,"date"=>$dr_date,"cat"=>$cat,"cat_by"=>$tid,"day"=>01,"month"=>$m,"year"=>$y1,"month_name"=>$month_name);    
                    //         $add_monthly_fee_dr=$this->LedgerModel->insert_data($monthly_fee_dr_array,$ledger_table);
                    
                    //     }
                    // }
            
                    for($m= 1;$m <=$curr_month ;$m++){
                        $dd=1;
                        $month_name='';
                        $date_new=''.$y1.'-'.$m.'-'.$dd.'';
                        $dr_date= date('Y-m-d',strtotime($date_new));
                        $get_course_month_fee=$this->LedgerModel->monthly_fee_structure($course_id,$acedemic_session);
                        $month_fee=0;
                        if($m ==1){
                            $month_name='january';
                        }else if($m == 2){
                            $month_name='february';
                        }else if($m == 3){
                            $month_name='march';
                        }
                        
                        
                        // if($m ==4){
                        //     $month_name='april';
                        // }else if($m == 5){
                        //     $month_name='may';
                        // }else if($m == 6){
                        //     $month_name='june';
                        // }else if($m == 7){
                        //     $month_name='july';
                        // }else if($m == 8){
                        //     $month_name='august';
                        // }else if($m == 9){
                        //     $month_name='september';
                        // }else if($m == 10){
                        //     $month_name='october';
                        // }else if($m ==11){
                        //     $month_name='november';
                        // }else if($m == 12){
                        //     $month_name='december';
                        // }
                
                
                        if($get_course_month_fee){
                            foreach($get_course_month_fee as $course_month_fee){
                                if($course_month_fee[$month_name] == 1){
                                    $month_fee=$month_fee + $course_month_fee['amount'];
                                }
                            }
                        }
                        $monthly_fee_type='monthly_fee';
                        $check_fee_dr_added=$this->LedgerModel->check_monthly_fee_debit_info($month_name,$sid,$acedemic_session,$monthly_fee_type,$dr_date,$ledger_table);
                        if($check_fee_dr_added){
                    
                        }else{
                            $monthly_fee_dr_array=array("particulars"=>"Monthly Fee","acedemic_session"=>$acedemic_session,"fee_type"=>$monthly_fee_type,"trans_type"=>"dr","sid"=>$sid,"debit"=>$month_fee,"date"=>$dr_date,"cat"=>$cat,"cat_by"=>$tid,"day"=>01,"month"=>$m,"year"=>$y1,"month_name"=>$month_name);    
                            $add_monthly_fee_dr=$this->LedgerModel->insert_data($monthly_fee_dr_array,$ledger_table);
                    
                        }
                    }
                }
        
        
                $get_monthly_fee_invoices=$this->LedgerModel->get_fee_invoices($sid,$acedemic_session);
                if($get_monthly_fee_invoices){
                    foreach($get_monthly_fee_invoices as $monthly_fee_invoices){
                        $monthly_fee_type='monthly_fee';
                        $fee_no=$monthly_fee_invoices['fee_no'];
                        $received_amount=$monthly_fee_invoices['received_amount'];
                        $balance_amount=$monthly_fee_invoices['balance_amount'];
                        $cr_fee_date=$monthly_fee_invoices['fee_date'];
                        $dayy=date('d',strtotime($cr_fee_date));
                        $monthh=date('m',strtotime($cr_fee_date));
                        $yearr=date('Y',strtotime($cr_fee_date));
                        $discount=$monthly_fee_invoices['discount'];
                        $payment_mode=$monthly_fee_invoices['payment_mode'];
                        $check_invoice_exist=$this->LedgerModel->fee_invoice_exist($sid,$monthly_fee_type,$fee_no,$ledger_table);
                        if($check_invoice_exist){
                    
                        }else{
                            $fee_invoice_array=array(
                                "particulars"=>"Monthly Fee",
                                "acedemic_session"=>$acedemic_session,
                                "fee_type"=>$monthly_fee_type,
                                "inv_no"=>$fee_no,
                                "trans_type"=>"Cr",
                                "sid"=>$sid,
                                "credit"=>$received_amount,
                                "payment_mode"=>$payment_mode,
                                "date"=>$cr_fee_date,
                                "cat"=>$cat,
                                "cat_by"=>$tid,
                                "day"=>$dayy,
                                "month"=>$monthh,
                                "year"=>$yearr
                            );
                            $add_fee_invoice=$this->LedgerModel->insert_data($fee_invoice_array,$ledger_table);
                            if($discount > 0){
                                $fee_discount_array=array(
                                    "particulars"=>"Monthly Fee",
                                    "acedemic_session"=>$acedemic_session,
                                    "fee_type"=>$monthly_fee_type,
                                    "inv_no"=>$fee_no,
                                    "trans_type"=>"Cr",
                                    "sid"=>$sid,
                                    "credit"=>$discount,
                                    "payment_mode"=>"Discount",
                                    "date"=>$cr_fee_date,
                                    "cat"=>$cat,
                                    "cat_by"=>$tid,
                                    "day"=>$dayy,
                                    "month"=>$monthh,
                                    "year"=>$yearr
                                );
                                $add_fee_invoice=$this->LedgerModel->insert_data($fee_discount_array,$ledger_table);
                            }
                        }
                
                
                    }
                }
            }
        }
    }
}