<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Import extends CI_Controller {
    
    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('NewFeeModel');
        $this->load->model('WelcomeModel');
        $this->load->model('ImportModel');
        $this->load->helper('date');
        $this->load->database();    
        $this->load->library('form_validation');
        $this->load->helper(array('form', 'url'));
        $this->load->library('session');
        $this->load->library('Pdf');
    }

    public function index(){
        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('import/imported-documents');
        $this->load->view('erp/footer');
        
    }

    public function upload_students(){
        $data['success']="";
        $data['error']="";

        ini_set("display_startup_errors",0);
        ini_set("display_errors",0);
        error_reporting(-1);
        require("/home1/hemchandra/cis.schoolassistant.in/application/libraries/SpreadsheetReader.php");
        require("/home1/hemchandra/cis.schoolassistant.in/application/libraries/Excel_reader2.php");
        if(isset($_POST['upload_students'])){
            $students_array=array();
            $academic_session=$_POST['academic_session'];
            $mimes = ['application/vnd.ms-excel','text/xls','text/xlsx','application/vnd.oasis.opendocument.spreadsheet'];
            $cat=date('Y-m-d H:i:s'); 
            $userid=$this->session->userdata("tid");
            $catt=date('Y-m-d-H-i-s');
            // echo $rand=rand(5, 15);
            $dir='new-assets/import-students/';
            $rand= mt_rand(9999,100000);
            $file_name1=basename($_FILES['file']['name']);
            $extension=explode(".",$file_name1);
            // echo end($var);
            $file_enc_name=$catt."-students.".end($extension);
            $file_name=$dir.$file_enc_name;
            move_uploaded_file($_FILES['file']['tmp_name'], $file_name);
            // $add_document_data
            $document_type="Student";
            $doc_status="Pending";
            $doc_data_array=array(
                "academic_session"=>$academic_session,
                "document_type"=>$document_type,
                "document_name"=>$file_enc_name,
                "status"=>$doc_status,
                "created_at"=>$cat,
                "created_by"=>$userid,
                "updated_at"=>$cat,
                "updated_by"=>$userid
            );
            $doc_table="import_documents";                
            $doc_id=$this->ImportModel->insert_data($doc_data_array,$doc_table);
            $import_count=0;
            if($doc_id){
                
                $Reader = new SpreadsheetReader($file_name);
                $totalSheet = count($Reader->sheets());
                $count=0;
                for($i=0;$i<$totalSheet;$i++){
                    $Reader->ChangeSheet($i);
                    foreach ($Reader as $Row){
                        $remove[] = "'";
                        $count= $count + 1;    
                        if($count > 1){
                            $admission_no = isset($Row[1]) ? $Row[1] : '';
                            $admission_date_1 = trim(isset($Row[2]) ? $Row[2] : '');
                            $student_name = trim(isset($Row[3]) ? $Row[3] : '');
                            $dob_1 = trim(isset($Row[4]) ? $Row[4] : '');
                            $gender = isset($Row[5]) ? $Row[5] : '';
                            $father_name = str_replace( $remove, "_", isset($Row[6]) ? $Row[6] : '' );
                            $mother_name = isset($Row[7]) ? $Row[7] : '';
                            $category = isset($Row[8]) ? $Row[8] : '';
                            $mobile_no = isset($Row[9]) ? $Row[9] : '';
                            $class = isset($Row[10]) ? $Row[10] : '';
                            $aadhar_no = isset($Row[11]) ? $Row[11] : '';
                            
                            $new_admission = isset($Row[12]) ? $Row[12] : '';
                            $section = isset($Row[13]) ? $Row[13] : '';
                            
                            $dob="";
                            if($dob_1 !=""){
                                $dob=date('Y-m-d',strtotime($dob_1));    
                            }
                            
                            $admission_date="";
                            if($admission_date_1 !=""){
                                $admission_date=date('Y-m-d',strtotime($admission_date_1));    
                            }
                            
                            
                            
                            
                            
                            $status="Pending";
                            $data_array=array(
                                "doc_id"=>$doc_id,
                                "admission_no"=>$admission_no,
                                "admission_date"=>$admission_date,
                                "student_name"=>$student_name,
                                "dob"=>$dob,
                                "gender"=>$gender,
                                "father_name"=>$father_name,
                                "mother_name"=>$mother_name,
                                "caste_category"=>$category,
                                "mobile_no"=>$mobile_no,
                                "class"=>$class,
                                "aadhar_no"=>$aadhar_no,
                                "status"=>$status,
                                "new_admission"=>$new_admission,
                                "section"=>$section,
                                "created_at"=>$cat,
                                "created_by"=>$userid,
                                "updated_at"=>$cat,
                                "updated_by"=>$userid
                            );
                            $doc_imp_student_table="import_students";
                            $add_student=$this->ImportModel->insert_data($data_array,$doc_imp_student_table);
                            if($add_student){
                                $import_count=$import_count + 1;
                            }

                        }
                    }
                }

                redirect(base_url()."Import/doc_data/".$doc_id);
            }else{
                $data['error']="Error In uploading Document";
            }

        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('import/import-students',$data);
        $this->load->view('erp/footer');
    }

    public function doc_data($id){
        $data['success']="";    $data['error']="";
        $table="import_students";
        $cat=date("Y-m-d H:i:s");
        $userid=$this->session->userdata("tid");
        if(isset($_POST['confirm_import_students'])){
            $doc_id=$_POST['doc_id'];
            $academic_session=$_POST['academic_session'];
            $get_doc_students=$this->ImportModel->get_doc_students_combined_data($doc_id);
            if($get_doc_students){
                foreach($get_doc_students as $students){
                    if($students['validation'] == 1 && $students['status'] == "Valid"){
                        $new_admission=$students['new_admission'];
                        $section=$students['section'];
                        $course_id=$students['current_course_id'];
                        $admission_date=$students['admission_date'];
                         	
                        $gender=$students['gender'];
                        $class=$students['class'];
                        $boy_girl="";
                        if($gender == "M"){
                            $boy_girl="Boy";
                        }else if($gender=="F"){
                            $boy_girl="Girl";
                        }
                        
                        $data_array=array(
                            "import_sid"=>$students['id'],
                            "adm_no"=>$students['admission_no'],
                            "admission_date"=>$students['admission_date'],
                            "student_name"=>$students['student_name'],
                            "dob"=>$students['dob'],
                            "gender"=>$students['gender'],
                            "boy_girl"=>$boy_girl,
                            "father_name"=>$students['father_name'],
                            "mother_name"=>$students['mother_name'],
                            "caste"=>$students['caste_category'],
                            "contact_no"=>$students['mobile_no'],
                            "aadhar_no"=>$students['aadhar_no'],
                            "status"=>1,
                            "cat"=>$cat,
                            "cat_by"=>$userid,
                            "updated_at"=>$cat,
                            "updated_by"=>$userid
                        );
                        $student_table="student";
                        
                        
                        $add_student=$this->ImportModel->insert_data($data_array,$student_table);
                        if($add_student){
                            $scd_array=array(
                                "sid"=>$add_student,
                                "new_admission"=>$new_admission,
                                "date_of_admission"=>$admission_date,
                                "acedemic_session"=>$academic_session,
                                "course_id"=>$course_id,
                                "class"=>$class,
                                "section"=>$section,
                                "new_admission"=>$new_admission,
                                "section"=>$section,
                                "status"=>1,
                                "cat"=>$cat,
                                "cat_by"=>$userid,
                                "uat"=>$cat,
                                "upd_by"=>$userid
                            );
                            $scd_table="student_courses_data";
                            $add_scd=$this->ImportModel->insert_data($scd_array,$scd_table);
                            $imp_stud_data_array_update=array(
                                "status"=>"Imported",
                                "sid"=>$add_student,
                                "updated_at"=>$cat,
                                "updated_by"=>$userid
                            );
                            $imp_sid=$students['id'];
                            $import_students_table="import_students";
                            $update_imp_stud_status=$this->ImportModel->update_item_data($imp_sid,$import_students_table,$imp_stud_data_array_update);
                        }
                        
                    }
                }
            }
            $import_doc_table="import_documents";
            $doc_data_array_update=array(
                "status"=>"Imported",
                "updated_at"=>$cat,
                "updated_by"=>$userid
            );
            $update_doc_data=$this->ImportModel->update_item_data($doc_id,$import_doc_table,$doc_data_array_update);
        }
        
        if(isset($_POST['validate_students'])){
            $doc_id=$_POST['doc_id'];
            $duplicate_count=0;
            $valid_count=0;
            $get_doc_students=$this->ImportModel->get_doc_data($doc_id,$table);
            if($get_doc_students){
                foreach($get_doc_students as $students){
                    $sid=$students['id'];
                    $student_name=$students['student_name'];
                    $mobile_no=$students['mobile_no'];
                    $dob=$students['dob'];
                    $class=$students['class'];
                    $validation_status='';
                    $validation=0;
                    $check_student_exists=$this->ImportModel->check_student_exists($student_name,$mobile_no,$dob);
                    if($get_student_data){
                        $validation_status="Duplicate";
                        $validation=2;
                        $duplicate_count=$duplicate_count + 1;
                    }else{
                        $validation_status="Valid";
                        $validation=1;
                        $valid_count=$valid_count + 1;
                    }
                    $data_array_update=array(
                        "validation"=>$validation,
                        "status"=>$validation_status,
                        "updated_at"=>$cat,
                        "updated_by"=>$userid
                    );
                    $update_student_data=$this->ImportModel->update_item_data($sid,$table,$data_array_update);
                    if($update_student_data){
                        
                    }else{
                        
                    }
                }
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('import/import-document-students',$data);
        $this->load->view('erp/footer');
    }
    
    
}