<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class FeeManagement extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('FeeModel');
        $this->load->model('WelcomeModel');
        $this->load->model('LoginModel');
        $this->load->model('AttendenceModel');
        // $this->load->model('CalenderModel');
        $this->load->model('SchoolModel');
        $this->load->model('NewFeeModel');
        $this->load->model('OpeningBalanceModel');
        $this->load->helper('date');
        $this->load->database();    
        $this->load->library('form_validation');
        $this->load->helper(array('form', 'url'));
        $this->load->library('session');
        $this->load->library('Pdf');
    }
    
    
    public function index(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/management/feemanagement/detailed_fee_portal');
        $this->load->view('erp/management/feemanagement/monthly-reports');
        $this->load->view('erp/footer');
    }
    
    public function course_fee_data($course_id){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/management/feemanagement/course_fee_portal');
        $this->load->view('erp/footer');
    }
    
    public function month_data($acedemic_session,$month){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/management/feemanagement/month_data');
        $this->load->view('erp/footer');
    }
    
    public function day_collection(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/management/feemanagement/day_collection');
        $this->load->view('erp/footer');
    }
    
    public function day_collection_pdf($from_date,$to_date){
        $hello=$this->uri->segment('3');
        // $this->load->view('erp/management/course_wise_students_pdf');
        // $this->load->view('erp/management/feemanagement/day_collection_pdf');
        $this->load->view('erp/management/feemanagement/day-collection-pdf-new');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
        $page_title=school_file_name."-".date("d-M-Y",strtotime($from_date))."-to-".date("d-M-Y",strtotime($to_date))."-Fee-Collection-Report";
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream($page_title, array("Attachment"=>0));
    }
    
    
    public function user_fee_collection($user_id,$from_date,$to_date){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/management/feemanagement/user_day_collection');
        $this->load->view('erp/footer');    
    }
    
    public function user_fee_collection_pdf(){
        $staff_id=$this->uri->segment('3');
        $from_date=$this->uri->segment('4');
        $to_date=$this->uri->segment('5');
    
        $user_table='school_staff';
        $user_name='';
    
        $get_user_info=$this->NewFeeModel->get_item_data($staff_id,$user_table);
        if($get_user_info){
            foreach($get_user_info as $user_info){
                $salutation=$user_info['salutation'];
                $user_name=$salutation." ".$user_info['name'];
            }
        }
        $title="Fee-Collection-On-".date("d-m-Y",strtotime($from_date))."-to-".date("d-m-Y",strtotime($from_date))."-by-".$user_name;
        
        // $this->load->view('erp/management/course_wise_students_pdf');
        $this->load->view('erp/management/feemanagement/user_day_collection_pdf');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$title", array("Attachment"=>0));
    }   
}