<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ExamResult extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('StudentModel');
        $this->load->model('ExamModel');
        $this->load->model('WelcomeModel');
        $this->load->model('NewFeeModel');
        $this->load->model('NewExamModel');
        $this->load->helper('date');
        $this->load->database();    
        $this->load->library('form_validation');
        $this->load->helper(array('form', 'url'));
        $this->load->library('session');
        //  $this->load->library('Pdf');
    }
    
    
    public function generate_result(){
        $course_id=$_POST['course_id'];
        $acedemic_session=$_POST['acedemic_session'];
        $exam_id=$_POST['exam_id'];  
        
        // $course_id=9;
        // $acedemic_session=3;
        // $exam_id=3;
        
        $class="";
        $courses_table="courses";
        $get_course_info=$this->NewExamModel->get_item_data($course_id,$courses_table);
        if($get_course_info){
            foreach($get_course_info as $course_info){
                $class=$course_info['course']." ".$course_info['subject_stream'];
            }
        }
        
        
        $subjects_table="exam_subjects_".$acedemic_session;
        $get_course_subjects=$this->NewExamModel->get_course_subjects($course_id,$subjects_table);
        
        $student_course_data_table="student_courses_data";
        $get_course_students=$this->NewExamModel->get_course_student($course_id,$acedemic_session);
        
        if($get_course_students){
            foreach($get_course_students as $students){
                
                $student_hy_total=0;
                $result_mm=0;
                
                $exam_result_table="exam_result";
                $sid=$students['sid'];
                
                
                
                $exam_log_table="exam_log_".$acedemic_session;
                $get_student_exam_log_data=$this->NewExamModel->students_exam_log($sid,$acedemic_session,$exam_log_table);
                
                $exam_heads_table="exam_heads_".$acedemic_session;
                $get_exam_heads=$this->NewExamModel->get_exam_heads($exam_heads_table);
                
                foreach($get_course_subjects as $course_subjects){
                    
                    $subject_id=$course_subjects['id'];
                    $subject=$course_subjects["subject"];
                    $subject_mm=$course_subjects['MM'];
                    $subject_type=$course_subjects['subject_type'];
                    $exam_type=$course_subjects['exam_type'];
                    $subject_marks_obtained=0;
                    $result_mm=$result_mm + $subject_mm;
                    if($exam_type == "Marks" && $subject_type == "Main Subject"){
                    
                    foreach($get_exam_heads as $exam_heads){
                        $ehid=$exam_heads['id'];
                        if($get_student_exam_log_data){
                            foreach($get_student_exam_log_data as $exam_log){
                                if($ehid == $exam_log['exam_head'] && $subject_id == $exam_log['subject_id']){
                                    $subject_marks_obtained =$subject_marks_obtained + $exam_log['obtained_marks'];
                                }else{
                                    
                                }
                            }
                        }
                    }
                    $cat=date('Y-m-d H:i:s');
                    $tid=$this->session->userdata('tid');
                    $student_hy_total=$student_hy_total + $subject_marks_obtained;
                    
                    
                    $data_array=array("sid"=>$sid,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"subject_id"=>$subject_id,"hy_total_marks"=>$subject_marks_obtained,"subject"=>$subject,"subject_mm"=>$subject_mm,"cat"=>$cat,"cat_by"=>$tid);
                    
                    
                    $data_array_update=array("subject"=>$subject,"subject_mm"=>$subject_mm,"hy_total_marks"=>$subject_marks_obtained,"uat"=>$cat,"upd_by"=>$tid);
                    
                    $student_subjects_table="student_subjects";
                    $get_student_subjects=$this->NewExamModel->get_student_subjects($sid,$course_id,$acedemic_session);
                    
                    $subject_exist=0;
                    if($get_student_subjects){
                        foreach($get_student_subjects as $student_subjects){
                            if($student_subjects['subject_id'] == $subject_id){
                                $subject_exist=$subject_exist + 1;    
                                
                            }
                        }    
                    }else{
                        
                    }
                    
                    // $add_subject_data=$this->NewExamModel->insert_data($data_array,$student_subjects_table);
                    // $update_subject_data=$this->NewExamModel->update_student_subjects_data($sid,$subject_id,$course_id,$acedemic_session,$student_subjects_table,$data_array_update);
                    
                    if($subject_exist == 1){
                        $update_subject_data=$this->NewExamModel->update_student_subjects_data($sid,$subject_id,$course_id,$acedemic_session,$student_subjects_table,$data_array_update);
                    }
                    if($subject_exist == 0){
                        $add_subject_data=$this->NewExamModel->insert_data($data_array,$student_subjects_table);
                    }
                    // echo $subject_exist."-".$subject."-";
                }
                    
                }
                $cat=date('Y-m-d H:i:s');
                $tid=$this->session->userdata('tid');
                    
                $percentage1=($student_hy_total * 100)/$result_mm;    
                $percentage=number_format((float)$percentage1, 2, '.', '');
                
                
                $y1=$this->session->userdata("y1");
                $y2=$this->session->userdata("y2");
                
                
                $result_data_array=array("exam_id"=>$exam_id,"sid"=>$sid,"y1"=>$y1,"y2"=>$y2,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"class"=>$class,"MM"=>$result_mm,"total_obtained_marks"=>$student_hy_total,"percentage"=>$percentage,"cat"=>$cat,"cat_by"=>$tid);
                $result_data_array_update=array("MM"=>$result_mm,"total_obtained_marks"=>$student_hy_total,"percentage"=>$percentage,"uat"=>$cat,"updated_by"=>$tid);
                
                $get_student_result_data=$this->NewExamModel->student_result($sid,$acedemic_session,$exam_id,$course_id,$exam_result_table);
                if($get_student_result_data){
                    $update_student_result_data=$this->NewExamModel->update_student_exam_data($sid,$exam_id,$course_id,$result_data_array_update,$exam_result_table);
                }else{
                    $add_exam_result=$this->NewExamModel->insert_data($result_data_array,$exam_result_table);
                }
                
                
                // echo $sid."<br>";
                    
            }
        }
        
        if($get_course_subjects){
            foreach($get_course_subjects as $subjects){
                $subject_id=$subjects['id'];
                $student_subjects_result="student_subjects";
                $get_course_student_subject_data=$this->NewExamModel->get_course_student_subject_hic_data($acedemic_session,$course_id,$subject_id,$student_subjects_result);
                $hic=0;
                if($get_course_student_subject_data){
                    foreach($get_course_student_subject_data as $data1){
                        $hic=$data1['hy_total_marks'];
                    }
                }
                $cat=date("Y-m-d H:i:s");
                $tid=$this->session->userdata('tid');
                $data_array_update=array("hy_hic"=>$hic,"uat"=>$cat,"updated_by"=>$tid);
                $update_hic=$this->NewExamModel->update_item_data($subject_id,$data_array_update,$subjects_table);
                
            }
        }
        
        $rank_count=0;
        $get_course_result=$this->NewExamModel->get_course_result($exam_id,$acedemic_session,$course_id,$exam_result_table);
        if($get_course_result){
            foreach($get_course_result as $result){
                $id=$result['id'];
                $rank_count=$rank_count + 1;        
                $cat=date("Y-m-d H:i:s");
                $tid=$this->session->userdata('tid');
                $data_array_update=array("rank_in_class"=>$rank_count,"uat"=>$cat,"updated_by"=>$tid);
                
                $update_hic=$this->NewExamModel->update_item_data($id,$data_array_update,$exam_result_table);
            }
        }
        
        
        // if($get_course_students){
        //     foreach($get_course_students as $students){
        //         $get_student_result_data=$this->NewExamModel->student_result($sid,$acedemic_session,$exam_id,$course_id,$exam_result_table);
        //         if($get_student_result_data){
        //             foreach($get_student_result_data as $result_data){
                        
        //             }
        //         }
        //     }
        // }
        echo "success";
        
    }
    
}

?>