<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ExamReport extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('NewExamModel');
        $this->load->model('ReportCardModel');
        $this->load->model('ExamManagementModel');
        $this->load->helper('date');
        $this->load->database();
        $this->load->library('form_validation');
        $this->load->helper(array('form', 'url'));
        $this->load->library('session');
        $this->load->library('Pdf');
    }
    
    
    public function index(){
        
    }
    
    public function first_term_report_card($class,$section,$exam_id){
        $course=$class."-".$section."-First-Term-Report-Cards";
        
        // $this->load->view('erp/report-card/new-landscape-report-card',true);
        // if($class == 9 || $class== 10 || $class == 11 || $class==12){
        //     $this->load->view('erp/report-card/course-report-card-final-hsc',true);    
        // }else if($class == 6 || $class == 7 || $class == 8){
        //     $this->load->view('erp/report-card/course-report-card-final-6-8',true);
        // }else if($class == 1 || $class == 2  || $class == 3 || $class == 4 || $class == 5 || $class == "PG" || $class == "LKG" || $class == "UKG"){
        //     $this->load->view('erp/exam-management/reports/class-1-to-5-first-term-report-card',true);
        // }
        if($class == 9){
            $this->load->view('erp/exam-management/reports/class-9-first-term-report-card',true);
        }else{
            $this->load->view('erp/exam-management/reports/class-1-to-5-first-term-report-card',true);    
        }
        
        
        // Get output html
        $html = $this->output->get_output();
        // $this->pdf->set_option( 'isJavascriptEnabled' , true );
        // Load HTML content
        $this->pdf->loadHtml($html);
        
        $this->pdf->set_option('enable-javascript', true);
        $this->pdf->set_option('images', true);
        $this->pdf->set_option('javascript-delay', 13000); // page load is quick but even a high number doesn't help
        $this->pdf->set_option('enable-smart-shrinking', true);
        $this->pdf->set_option('no-stop-slow-scripts', true);
    
        $old_limit = ini_set("memory_limit", "51200M");
        // (Optional) Setup the paper size and orientation
        // $this->pdf->setPaper('A4', 'portrait');
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$course", array("Attachment"=>0));
    }
    
    // public function second_term_report_card($class,$section,$exam_id){
        
    // }
    
    // public function annual_combined_report_card($class,$section,$exam_id){
        
    // }
    
    public function second_term_report_card($class,$section,$exam_id){
        $course=school_file_name.'-'.$class."-".$section."-Second-Term-Report-Cards";
        
        if($class == 11 || $class == 9){
            // $this->load->view('erp/exam-management/reports/class-11-and-12-first-term-report-card.php',true);
            $this->load->view('erp/exam-management/reports/class-11-and-12-second-term-report-card-new',true);
        }else if($class == "NURSERY" || $class == "LKG" || $class == "UKG" || $class == "PLAY"){
            // $this->load->view('erp/exam-management/reports/kg-section-second-term-report-card');
            // $this->load->view('erp/exam-management/reports/class-1-to-5-second-term-report-card',true);
            $this->load->view('erp/exam-management/reports/kg-section-second-term-report-card',true);
        }else if($class == "1" || $class == "2" || $class == "3" || $class == "4" || $class== "5"){
            $this->load->view('erp/exam-management/reports/class-1-to-5-second-term-report-card',true);
        }else if($class == "6" || $class == "7" || $class == "8"){
            $this->load->view('erp/exam-management/reports/class-6-to-8-second-term-report-card',true);
        }
        // Get output html
        $html = $this->output->get_output();
        // $this->pdf->set_option( 'isJavascriptEnabled' , true );
        // Load HTML content
        $this->pdf->loadHtml($html);
        
        $this->pdf->set_option('enable-javascript', true);
        $this->pdf->set_option('images', true);
        $this->pdf->set_option('javascript-delay', 13000); // page load is quick but even a high number doesn't help
        $this->pdf->set_option('enable-smart-shrinking', true);
        $this->pdf->set_option('no-stop-slow-scripts', true);
    
        $old_limit = ini_set("memory_limit", "51200M");
        // (Optional) Setup the paper size and orientation
        // $this->pdf->setPaper('A4', 'portrait');
        $this->pdf->setPaper('A4', 'landscape');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$course", array("Attachment"=>0));
    }
    
    public function annual_combined_report_card($class,$section,$exam_id){
        $course=school_file_name.'-'.$class."-".$section."-Second-Term-Report-Cards-Front-PAGE";
        
        // $this->load->view('erp/exam-management/reports/class-1-to-5-second-term-combined-report-card-new');
        if($class == 9 || $class == 11){
            $this->load->view('erp/exam-management/reports/class-9-to-11-second-term-back-side-report-card-new');    
        }else{
            // $this->load->view('erp/exam-management/reports/class-1-to-5-second-term-back-side-report-card-new');
            $this->load->view('erp/exam-management/reports/class-1-to-8-second-term-back-side-report-card-new');
        }
        
        // Get output html
        $html = $this->output->get_output();
        // $this->pdf->set_option( 'isJavascriptEnabled' , true );
        // Load HTML content
        $this->pdf->loadHtml($html);
        
        $this->pdf->set_option('enable-javascript', true);
        $this->pdf->set_option('images', true);
        $this->pdf->set_option('javascript-delay', 13000); // page load is quick but even a high number doesn't help
        $this->pdf->set_option('enable-smart-shrinking', true);
        $this->pdf->set_option('no-stop-slow-scripts', true);
    
        $old_limit = ini_set("memory_limit", "51200M");
        // (Optional) Setup the paper size and orientation
        // $this->pdf->setPaper('A4', 'portrait');
        $this->pdf->setPaper('A4', 'landscape');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$course", array("Attachment"=>0));
    }
    
}