<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Certificate extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('NewFeeModel');
        $this->load->model('WelcomeModel');
        // $this->load->model('OpeningBalanceModel');
        $this->load->model('CertificateModel');
        $this->load->helper('date');
        $this->load->database();
        $this->load->library('form_validation');
        $this->load->helper(array('form', 'url'));
        $this->load->library('session');
        $this->load->library('Pdf');
    }
    
    public function dashboard(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/certificate/certificate-dashboard');
        $this->load->view('erp/footer');
    }
    
    public function students(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/certificate/students');
        $this->load->view('erp/footer');
    }
    
    public function student_docs(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/certificate/student-docs');
        $this->load->view('erp/footer');
    }
    
    public function issue_student_certificate(){
        $data['success']='';$data['error']='';
        if(isset($_POST['issue_student_bonafied_certificate'])){
            $doc_id=$_POST['doc_id'];
            $sid=$this->input->post('sid');
            $student_name=$this->input->post('student_name');
            $father_name=$this->input->post('father_name');
            $doc_type=$this->input->post('doc_type');
            $doc_copy_order=$this->input->post('doc_copy_order');
            $dob=$this->input->post('dob');
            $course=$this->input->post('course');
            $dob_in_words=$this->input->post('dob_in_words');
            $issuing_date=$this->input->post('issuing_date');
            $gender=$this->input->post('gender');
            $salutation=$this->input->post('salutation');
            $acedemic_session=$this->input->post('acedemic_session');
            $cat=date('Y-m-d H:i:s');
            $tid=$this->session->userdata('tid');
            $doc_fee=$this->input->post('doc_fee');
            
            $mother_name_salutation=$_POST['mother_name_salutation'];
            $mother_name=$_POST['mother_name'];
            
            $date=date('Y-m-d');
            $data_array=array("sid"=>$sid,"student_name"=>$student_name,"father_name"=>$father_name,"doc_type"=>$doc_type,"doc_copy_order"=>$doc_copy_order,"dob"=>$dob,"dob_in_words"=>$dob_in_words,"issuing_date"=>$issuing_date,"course"=>$course,"cat"=>$cat,"cat_by"=>$tid,"fee"=>$doc_fee,"date"=>$date,"gender"=>$gender,"salutation"=>$salutation,"acedemic_session"=>$acedemic_session,"mother_name"=>$mother_name,"mother_name_salutation"=>$mother_name_salutation);
            
            $table='student_bonafied_certificate';                        
            $get_doc_data=$this->CertificateModel->get_item_data($doc_id,$table);
            if($get_doc_data){
                $data_array_update=array("sid"=>$sid,"student_name"=>$student_name,"father_name"=>$father_name,"doc_type"=>$doc_type,"doc_copy_order"=>$doc_copy_order,"dob"=>$dob,"dob_in_words"=>$dob_in_words,"issuing_date"=>$issuing_date,"course"=>$course,"uat"=>$cat,"upd_by"=>$tid,"fee"=>$doc_fee,"date"=>$date,"gender"=>$gender,"salutation"=>$salutation,"acedemic_session"=>$acedemic_session,"mother_name"=>$mother_name,"mother_name_salutation"=>$mother_name_salutation);
                $update_doct_data=$this->CertificateModel->update_item_data($doc_id,$table,$data_array_update);
                if($update_doct_data){
                    $data['success']='Updated Successfully';
                }else{
                    $data['error']='Error in updating document';
                }
            }else{
                $check_doc_duplicacy=$this->CertificateModel->check_doc_date_and_type($sid,$doc_type,$issuing_date,$table);
                if($check_doc_duplicacy){
                    $data['error']='Already issued the Doc. for this date. try with some another date';
                }else{
                    $gen_certificate=$this->CertificateModel->insert_data($data_array,$table);
                    if($gen_certificate){
                        $data['success']='Certificate Genrated Successfully';
                    }else{
                        $data['error']='Error in genrating certificate.';
                    }
                }
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/certificate/issue-student-bonafide-certificate',$data);
        $this->load->view('erp/footer');
    }
    
    
    public function student_certificate($doc_no){
        $this->load->view('erp/certificate/student-certificate');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$doc_no", array("Attachment"=>0));
    }
    
    
    
    public function issue_transfer_certificate(){
        $data['success']='';$data['error']='';
        
        if(isset($_POST['issue_transfer_certificate'])){
            $doc_id=$_POST['doc_id'];
            $sid=$this->input->post('sid');
            $sch_no=$_POST['sch_no'];
            $student_name=$this->input->post('student_name');
            $father_name=$this->input->post('father_name');
            $doc_type=$this->input->post('doc_type');
            $doc_copy_order=$this->input->post('doc_copy_order');
            $dob=$this->input->post('dob');
            $course=$this->input->post('course');
            $dob_in_words=$this->input->post('dob_in_words');
            $issuing_date=$this->input->post('issuing_date');
            $gender=$this->input->post('gender');
            $salutation=$this->input->post('salutation');
            $acedemic_session=$this->input->post('acedemic_session');
            $cat=date('Y-m-d H:i:s');
            $tid=$this->session->userdata('tid');
            $doc_fee=$this->input->post('doc_fee');
            $date=date('Y-m-d');
            
            
            $mother_name=$_POST['mother_name'];
            $mother_name_salutation=$_POST['mother_name_salutation'];
            
            $admission_class=$_POST['admission_class'];
            
            $admission_date=$this->input->post('admission_date');
            $previous_school=$this->input->post('previous_school');
            $school_leaving_date=$this->input->post('school_leaving_date');
            $school_stream=$this->input->post('school_stream');
            $ac_year_start=$this->input->post('ac_year_start');
            $ac_year_end=$this->input->post('ac_year_end');
            $promotion=$this->input->post('promotion');
            $charcter_info=$this->input->post('charcter_info');
            $data_array=array("sid"=>$sid,"student_name"=>$student_name,"father_name"=>$father_name,"doc_type"=>$doc_type,"doc_copy_order"=>$doc_copy_order,"dob"=>$dob,"dob_in_words"=>$dob_in_words,"issuing_date"=>$issuing_date,"course"=>$course,"cat"=>$cat,"cat_by"=>$tid,"fee"=>$doc_fee,"date"=>$date,"gender"=>$gender,"salutation"=>$salutation,"acedemic_session"=>$acedemic_session,"admission_date"=>$admission_date,"previous_school"=>$previous_school,"school_leaving_date"=>$school_leaving_date,"school_stream"=>$school_stream,"ac_year_start"=>$ac_year_start,"ac_year_end"=>$ac_year_end,"promotion"=>$promotion,"charcter_info"=>$charcter_info,"sch_no"=>$sch_no,"admission_class"=>$admission_class,"mother_name_salutation"=>$mother_name_salutation,"mother_name"=>$mother_name);
            $data_array_update=array("sid"=>$sid,"student_name"=>$student_name,"father_name"=>$father_name,"doc_type"=>$doc_type,"doc_copy_order"=>$doc_copy_order,"dob"=>$dob,"dob_in_words"=>$dob_in_words,"issuing_date"=>$issuing_date,"course"=>$course,"uat"=>$cat,"upd_by"=>$tid,"fee"=>$doc_fee,"date"=>$date,"gender"=>$gender,"salutation"=>$salutation,"acedemic_session"=>$acedemic_session,"admission_date"=>$admission_date,"previous_school"=>$previous_school,"school_leaving_date"=>$school_leaving_date,"school_stream"=>$school_stream,"ac_year_start"=>$ac_year_start,"ac_year_end"=>$ac_year_end,"promotion"=>$promotion,"charcter_info"=>$charcter_info,"sch_no"=>$sch_no,"admission_class"=>$admission_class,"mother_name_salutation"=>$mother_name_salutation,"mother_name"=>$mother_name);
            $table='student_transfer_certificate';                        
            if($doc_id !=''){
                $get_student_doc_info=$this->CertificateModel->get_item_data($doc_id,$table);    
                if($get_student_doc_info){
                    $update_item_data=$this->CertificateModel->update_item_data($doc_id,$table,$data_array_update);
                    if($update_item_data){
                        $data['success']='Updated Successfully';
                    }else{
                        $data['error']='Error in updating transfer certificate';
                    }
                }
            }else{
                $check_doc_duplicacy=$this->CertificateModel->check_doc_date_and_type($sid,$doc_type,$issuing_date,$table);
                if($check_doc_duplicacy){
                    $data['error']='Already issued the Doc. for this date. try with some another date';
                }else{
                    $gen_certificate=$this->CertificateModel->insert_data($data_array,$table);
                    if($gen_certificate){
                        $data['success']='Certificate Genrated Successfully';
                    }else{
                        $data['error']='Error in genrating certificate.';
                    }
                }
            }
        }
        
        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/certificate/issue-transfer-certificate',$data);
        $this->load->view('erp/footer');
    }
    
    public function update_transfer_certificate(){
        $data['success']=''; $data['error']='';
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/certificate/edit-transfer-certificate',$data);
        $this->load->view('erp/footer');
    }
    
    public function transfer_certificate($doc_no){
        // $this->load->view('erp/certificate/transfer-certificate');
        $this->load->view('erp/certificate/transfer-certificate-new');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("Transfer-Certificate-".$doc_no."", array("Attachment"=>0));
    }
    
    public function transfer_certificate_new($doc_no){
        $this->load->view('erp/certificate/transfer-certificate-new');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A5', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("Transfer-Certificate-".$doc_no."", array("Attachment"=>0));
    }
    
    public function issue_character_certificate(){
        $data['success']=""; $data['error']="";
        if(isset($_POST['issue_student_character_certificate'])){
            $doc_id=$_POST['doc_id'];
            $sid=$_POST['sid'];
            $student_name=$_POST['student_name'];
            $gender=$_POST['gender'];
            $father_salutation=$_POST['father_salutation'];
            $father_name=$_POST['father_name'];
            $mother_name_salutation=$_POST['mother_name_salutation'];
            $mother_name=$_POST['mother_name'];
            $course=$_POST['course'];
            $doc_type=$_POST['doc_type'];
            $doc_copy_order=$_POST['doc_copy_order'];
            $issuing_date=$_POST['issuing_date'];
            $dob=$_POST['dob'];
            $dob_in_words=$_POST['dob_in_words'];
            $admission_date=$_POST['admission_date'];
            $to_date=$_POST['to_date'];
            $exam_status=$_POST['exam_status'];
            $appeared_in=$_POST['appeared_in'];
            $examination_year=$_POST['examination_year'];
            $doc_fee=$_POST['doc_fee'];
            $conduct=$_POST['conduct'];
            $in_school=$_POST['in_school'];
            $cat=date('Y-m-d H:i:s');
            $userid=$this->session->userdata('tid');
            //  	 	 	 	
            $acedemic_session=$this->session->userdata('acedemic_session');
            $data_array=array("sid"=>$sid,"acedemic_session"=>$acedemic_session,"student_name"=>$student_name,"salutation"=>$father_salutation,"father_name"=>$father_name,"mother_name_salutation"=>$mother_name_salutation,"mother_name"=>$mother_name,"gender"=>$gender,"doc_type"=>$doc_type,"doc_copy_order"=>$doc_copy_order,"dob"=>$dob,"dob_in_words"=>$dob_in_words,"issuing_date"=>$issuing_date,"course"=>$course,"fee"=>$doc_fee,"admission_date"=>$admission_date,"to_date"=>$to_date,"status"=>$exam_status,"appeared_in"=>$appeared_in,"examination_year"=>$examination_year,"conduct"=>$conduct,"date"=>date('Y-m-d'),"cat"=>$cat,"cat_by"=>$userid,"in_school"=>$in_school);
            
            $data_array_update=array("sid"=>$sid,"acedemic_session"=>$acedemic_session,"student_name"=>$student_name,"salutation"=>$father_salutation,"father_name"=>$father_name,"mother_name_salutation"=>$mother_name_salutation,"mother_name"=>$mother_name,"gender"=>$gender,"doc_type"=>$doc_type,"doc_copy_order"=>$doc_copy_order,"dob"=>$dob,"dob_in_words"=>$dob_in_words,"issuing_date"=>$issuing_date,"course"=>$course,"fee"=>$doc_fee,"admission_date"=>$admission_date,"to_date"=>$to_date,"status"=>$exam_status,"appeared_in"=>$appeared_in,"examination_year"=>$examination_year,"conduct"=>$conduct,"date"=>date('Y-m-d'),"uat"=>$cat,"upd_by"=>$userid,"in_school"=>$in_school);
            
            $character_certificate_table="student_character_certificate";
            $get_character_doc_data=$this->CertificateModel->get_item_data($doc_id,$character_certificate_table);
            if($get_character_doc_data){
                $update_certificate_data=$this->CertificateModel->update_item_data($doc_id,$character_certificate_table,$data_array_update);
                if($update_certificate_data){
                    $data['success']="Document Information Updated Successfully";
                }else{
                    $data['error']="Error in adding new document.";
                }
                
            }else{
                $add_new_doc=$this->CertificateModel->insert_data($data_array,$character_certificate_table);
                if($add_new_doc){
                    $data['success']="New Character Document Added Successfully";
                }else{
                    $data['error']="Error in generating New Document.";
                }
            }
            
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/certificate/issue-character-certificate',$data);
        $this->load->view('erp/footer');
    }
    
    public function character_certificate($id){
        // $this->load->view('erp/certificate/charcter_certificate');
        $this->load->view('erp/certificate/student-charcter-certificate');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("character-certificate-".$id."", array("Attachment"=>0));
    }
    
    public function reimbursment_cea_certificate($id){
        $this->load->view('erp/certificate/reimbursment_cea_certificate');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
        $doc_name="Reimbursment-Cea-Certificate-".$id;
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$doc_name", array("Attachment"=>0));
    }
    
    public function student_fee_certificate($id){
        $this->load->view('erp/certificate/student-fee-certificate');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
        $doc_name="Student-Fee--Certificate-".$id;
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$doc_name", array("Attachment"=>0));
    }
    public function issue_reimbursment_cea_certificate(){
        $data['success']=''; $data['error']='';
        if(isset($_POST['issue_reimbursment_cea_certificate'])){
            $doc_id=$_POST['doc_id'];
            $sid=$_POST['sid'];
            $refrence_number=$_POST['refrence_number'];
            $sch_no=$_POST['sch_no'];
            $student_name=$_POST['student_name'];
            $salutation=$_POST['salutation'];
            $father_name=$_POST['father_name'];
            $gender=$_POST['gender'];
            $course=$_POST['course'];
            $section=$_POST['section'];
            $roll_no=$_POST['roll_no'];
            $doc_type=$_POST['doc_type'];
            $doc_copy_order=$_POST['doc_copy_order'];
            $issuing_date=$_POST['issuing_date'];
            $dob=$_POST['dob'];
            $acedemic_session=$_POST['acedemic_session'];
            $doc_fee=$_POST['doc_fee'];
            $ac_year_start=$_POST['ac_year_start'];
            $ac_year_end=$_POST['ac_year_end'];
            $school_code=$_POST['school_code'];
            $pattern=$_POST['pattern'];
            $place=$_POST['place'];
            $userid=$this->session->userdata('tid');
            
            $cat=date('Y-m-d H:i:s');
            // 	ref_no							parent					prev_acedemic_year				doc_fee		
            
            $data_array=array("sid"=>$sid,"issuing_date"=>$issuing_date,"dob"=>$dob,"student_name"=>$student_name,"salutation"=>$salutation,"parent_name"=>$father_name,"gender"=>$gender,"sch_no"=>$sch_no,"roll_no"=>$sch_no,"class"=>$course,"sec"=>$section,"doc_copy_order"=>$doc_copy_order,"ac_year_start"=>$ac_year_start,"ac_year_end"=>$ac_year_end,"place"=>$place,"cat"=>$cat,"cat_by"=>$userid,"doc_type"=>$doc_type,"acedemic_session"=>$acedemic_session);
            $table='reimbursment_cea_certificate';
            $get_document_data=$this->CertificateModel->get_item_data($doc_id,$table);
            if($get_document_data){
                $data_array_update=array("issuing_date"=>$issuing_date,"dob"=>$dob,"student_name"=>$student_name,"salutation"=>$salutation,"parent_name"=>$father_name,"gender"=>$gender,"sch_no"=>$sch_no,"roll_no"=>$sch_no,"class"=>$course,"sec"=>$section,"doc_copy_order"=>$doc_copy_order,"ac_year_start"=>$ac_year_start,"ac_year_end"=>$ac_year_end,"place"=>$place,"doc_type"=>$doc_type,"acedemic_session"=>$acedemic_session,"uat"=>$cat,"upd_by"=>$userid);
                
                $update_certificate_data=$this->CertificateModel->update_item_data($doc_id,$table,$data_array_update);
                if($update_certificate_data){
                    $data['success']='Updated Successfully';
                }else{
                    $data['error']='Error in updating document data';
                }
            }else{
                
                
                $check_document_exist=$this->CertificateModel->check_doc_date_and_type($sid,$doc_type,$issuing_date,$table);
                if($check_document_exist){
                    $data['error']='Document Already Genrated';
                }else{
                    $add_data=$this->CertificateModel->insert_data($data_array,$table);
                    if($add_data){
                        $data['success']='Document Genrated Successfully';
                    }else{
                        $data['error']='Error in genrating Document';
                    }
                }
                
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/certificate/issue_reimbursment_cea_certificate',$data);
        $this->load->view('erp/footer');
    }
    
    
    public function issue_fee_certificate(){
        $data['success']=''; $data['error']='';
        if(isset($_POST['issue_fee_certificate'])){
            $salutation=$_POST['salutation'];
            $doc_id=$_POST['doc_id'];
            $sid=$_POST['sid'];
            $refrence_number=$_POST['refrence_number'];
            $sch_no=$_POST['sch_no'];
            $student_name=$_POST['student_name'];
            $gender=$_POST['gender'];
            $father_name=$_POST['father_name'];
            $course_id=$_POST['course'];
            $section=$_POST['section'];
            $roll_no=$_POST['roll_no'];
            $acedemic_session=$_POST['acedemic_session'];
            $ac_year_start=$_POST['ac_year_start'];
            $ac_year_end=$_POST['ac_year_end'];
            $doc_type=$_POST['doc_type'];
            $doc_copy_order=$_POST['doc_copy_order'];
            $issuing_date=$_POST['issuing_date'];
            $school_code=$_POST['school_code'];
            $pattern=$_POST['pattern'];
            $doc_fee=$_POST['doc_fee'];
            $tution_fee=$_POST['tution_fee'];
            $term_charge=$_POST['term_charge'];
            $discount=$_POST['discount'];
            $total_fee=$_POST['total_fee'];
            $cat=date('Y-m-d H:i:s');
            $userid=$this->session->userdata('tid');
            $fee_in_words=$this->convert_number($total_fee);
            $table='student_fee_certificate';
            
            $mother_name_salutation=$_POST['mother_name_salutation'];
            $mother_name=$_POST['mother_name'];
            
            
            $course='';
            $subject_stream='';
            $course_table='courses';
            $get_course_info=$this->CertificateModel->get_item_data($course_id,$course_table);
            if($get_course_info){
                foreach($get_course_info as $course_info){
                    $course=$course_info['course'];
                    $subject_stream=$course_info['subject_stream'];
                }
            }
            $data_array=array("sid"=>$sid,"acedemic_session"=>$acedemic_session,"ac_year_start"=>$ac_year_start,"ac_year_end"=>$ac_year_end,"course_id"=>$course_id,"class"=>$course,"subject_stream"=>$subject_stream,"issuing_date"=>$issuing_date,"student_name"=>$student_name,"salutation"=>$salutation,"father_name"=>$father_name,"gender"=>$gender,"doc_type"=>$doc_type,"doc_copy_order"=>$doc_copy_order,"doc_fee"=>$doc_fee,"tution_fee"=>$tution_fee,"term_charges"=>$term_charge,"discount"=>$discount,"total_fee"=>$total_fee,"school_code"=>$school_code,"pattern"=>$pattern,"school_full_name"=>school_full_name,"sch_no"=>$sch_no,"ref_no"=>$refrence_number,"cat"=>$cat,"cat_by"=>$userid,"total_fee_in_words"=>$fee_in_words,"section"=>$section,"mother_name"=>$mother_name,"mother_name_salutation"=>$mother_name_salutation);
            
            if($doc_id != ''){
                $get_doc_data=$this->CertificateModel->get_item_data($doc_id,$table);
                if($get_doc_data){
                    $data_array_update=array("acedemic_session"=>$acedemic_session,"ac_year_start"=>$ac_year_start,"ac_year_end"=>$ac_year_end,"course_id"=>$course_id,"class"=>$course,"subject_stream"=>$subject_stream,"issuing_date"=>$issuing_date,"student_name"=>$student_name,"salutation"=>$salutation,"father_name"=>$father_name,"gender"=>$gender,"doc_type"=>$doc_type,"doc_copy_order"=>$doc_copy_order,"doc_fee"=>$doc_fee,"tution_fee"=>$tution_fee,"term_charges"=>$term_charge,"discount"=>$discount,"total_fee"=>$total_fee,"school_code"=>$school_code,"pattern"=>$pattern,"school_full_name"=>school_full_name,"sch_no"=>$sch_no,"ref_no"=>$refrence_number,"uat"=>$cat,"upd_by"=>$userid,"total_fee_in_words"=>$fee_in_words,"section"=>$section,"mother_name"=>$mother_name,"mother_name_salutation"=>$mother_name_salutation);
                    $update_doc_data=$this->CertificateModel->update_item_data($doc_id,$table,$data_array_update);
                    if($update_doc_data){
                        $data['success']='Updated Successfully';
                    }else{
                        $data['error']='Error in updating data';
                    }
                }
            }else{
                $check_document_exist=$this->CertificateModel->check_doc_date_and_type($sid,$doc_type,$issuing_date,$table);
                if($check_document_exist){
                    $data['error']='Document Already Genrated';
                }else{
                    $add_data=$this->CertificateModel->insert_data($data_array,$table);
                    if($add_data){
                        $data['success']='Document Genrated Successfully';
                    }else{
                        $data['error']='Error in genrating Document';
                    }
                
                }   
            }
        }
        // tution_fee();
        // ter_charges();
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/certificate/issue_fee_certificate',$data);
        $this->load->view('erp/footer');
    }
    
    public function test_num_to_word(){
        $number=209;
        // echo $this->numberTowords($number);
        $total_fee=29400;
        echo $fee_in_words=$this->convert_number($total_fee);
    }
    public function convert_number($number) 
    {
        if (($number < 0) || ($number > 999999999)) 
        {
            throw new Exception("Number is out of range");
        }
        $giga = floor($number / 1000000);
        // Millions (giga)
        $number -= $giga * 1000000;
        $kilo = floor($number / 1000);
        // Thousands (kilo)
        $number -= $kilo * 1000;
        $hecto = floor($number / 100);
        // Hundreds (hecto)
        $number -= $hecto * 100;
        $deca = floor($number / 10);
        // Tens (deca)
        $n = $number % 10;
        // Ones
        $result = "";
        if ($giga) 
        {
            $result .= $this->convert_number($giga) .  "Million";
        }
        if ($kilo) 
        {
            $result .= (empty($result) ? "" : " ") .$this->convert_number($kilo) . " Thousand";
        }
        if ($hecto) 
        {
            $result .= (empty($result) ? "" : " ") .$this->convert_number($hecto) . " Hundred";
        }
        $ones = array("", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eightteen", "Nineteen");
        $tens = array("", "", "Twenty", "Thirty", "Fourty", "Fifty", "Sixty", "Seventy", "Eigthy", "Ninety");
        if ($deca || $n) {
            if (!empty($result)) 
            {
                $result .= " and ";
            }
            if ($deca < 2) 
            {
                $result .= $ones[$deca * 10 + $n];
            } else {
                $result .= $tens[$deca];
                if ($n) 
                {
                    $result .= "-" . $ones[$n];
                }
            }
        }
        if (empty($result)) 
        {
            $result = "zero";
        }
        return $result;
    }
    
    
    public function numberTowords($num){ 

        $ones = array(
            0 =>"ZERO", 1 => "FIRST", 2 => "SECOND", 3 => "THIRD", 4 => "FOURTH", 5 => "FIFTH", 6 => "SIXTH", 7 => "SEVENTH", 8 => "EIGHTH", 9 => "NINTH",10 => "TEN", 11 => "ELEVENTH", 12 => "TWELFTH", 13 => "THIRTEENTH", 14 => "FOURTEENTH", 15 => "FIFTEENTH", 16 => "SIXTEENTH", 17 => "SEVENTEENTH", 18 => "EIGHTEENTH", 19 => "NINETEENTH"); 
        $tens = array( 0 => "ZERO",1 => "TEN",2 => "TWENTY", 3 => "THIRTY", 4 => "FORTY", 5 => "FIFTY", 6 => "SIXTY", 7 => "SEVENTY", 8 => "EIGHTY", 9 => "NINETY");
        $hundreds = array( "HUNDRED", "THOUSAND","MILLION", "BILLION", "TRILLION","QUARDRILLION" ); /* limit t quadrillion */
        $num = number_format($num,2,".",",");
        $num_arr = explode(".",$num); 
        $wholenum = $num_arr[0]; 
        $decnum = $num_arr[1]; 
        $whole_arr = array_reverse(explode(",",$wholenum)); 
        krsort($whole_arr,1); 
        $rettxt = ""; 
        foreach($whole_arr as $key => $i){
	
            while(substr($i,0,1)=="0")
		        $i=substr($i,1,5);
                if($i < 20){ 
                    /* echo "getting:".$i; */
                    $rettxt .= $ones[$i]; 
                }elseif($i < 100){ 
                    if(substr($i,0,1)!="0")  $rettxt .= $tens[substr($i,0,1)]; 
                    if(substr($i,1,1)!="0") $rettxt .= " ".$ones[substr($i,1,1)]; 
                }else{ 
                    if(substr($i,0,1)!="0") $rettxt .= $ones[substr($i,0,1)]." ".$hundreds[0]; 
                    if(substr($i,1,1)!="0")$rettxt .= " ".$tens[substr($i,1,1)]; 
                    if(substr($i,2,1)!="0")$rettxt .= " ".$ones[substr($i,2,1)]; 
                } 
                if($key > 0){ 
                    $rettxt .= " ".$hundreds[$key]." "; 
                } 
        } 
        if($decnum > 0){ 
            $rettxt .= " and "; 
            if($decnum < 20){ 
                $rettxt .= $ones[$decnum]; 
            }elseif($decnum < 100){ 
                $rettxt .= $tens[substr($decnum,0,1)]; 
                $rettxt .= " ".$ones[substr($decnum,1,1)]; 
            } 
        } 
        return $rettxt; 
    } 
    
}