<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Accounts extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('DeveloperModel');
        $this->load->model('NewFeeModel');
        $this->load->model('AccountsModel');
        $this->load->model('WelcomeModel');
        $this->load->helper('date');
        $this->load->database();    
        $this->load->library('form_validation');
        $this->load->library('session');
        $this->load->library('Pdf');
    }
    public function index(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/accounts/index');
        $this->load->view('erp/footer');
    }
    
    public function add_new_head(){
        $data['success']='';    $data['error']='';
        if(isset($_POST['add_account_head'])){
            $account_head=$_POST['account_head'];
            $account_head_type=$_POST['account_head_type'];
            $status=1;
            $cat=date('Y-m-d H:i:s');
            $userid=$this->session->userdata('tid');
            
            
            
            $data_array=array("head"=>$account_head,"head_type"=>$account_head_type,"status"=>$status,"cat"=>$cat,"cat_by"=>$userid);
            $table='account_heads';
            
            $add_account_head=$this->AccountsModel->insert_data($data_array,$table);
            if($add_account_head){
                $data['success']='Account Head Added Successfully';
            }else{
                $data['error']='Error in adding account head';
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/accounts/add-account-head',$data);
        $this->load->view('erp/footer');
    }
    
    public function all_heads(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/accounts/all-heads');
        $this->load->view('erp/footer');
    }
    
    public function add_new_record(){
        $data['success']='';    $data['error']='';
        $data['id']='';
        if(isset($_POST['edit'])){
            $data['id']=$_POST['edit'];
        }
        if(isset($_POST['add_new_record'])){
            $record_id=$_POST['record_id'];
            $acedemic_session=$_POST['acedemic_session'];
            $particulars=$_POST['particulars'];
            $account_head_type=$_POST['account_head_type'];
            $date=$_POST['date'];
            $amount=$_POST['amount'];
            $acedemic_year='';
            $description=$_POST['description'];
            $account_heads_table='account_heads';
            $account_head_data=$this->AccountsModel->get_item_data($particulars,$account_heads_table);
            $particular_type='';
            if($account_head_data){
                foreach($account_head_data as $head_data){
                    $particular_type=$head_data['head'];
                }
            }
            
            // $slug=$this->slugify($particulars);
            $attachment='';
            $catt=date('Y-m-d-H-i-s');
            $attachment='';
            if($_FILES['attachment']['name']){
                // $category_image = preg_replace("/[^a-zA-Z0-9.-]+/","", $_FILES['slide_banner']['name']);
                // $product_img = mt_rand(999999,9999999).'-'.$product_img;
                $file_name=$_FILES['attachment']['name'];
                $tmp = explode('.', $file_name);
                $file_ext = strtolower(end($tmp));
                $attachment=$catt."-".$particular_type.".".$file_ext;
                
                move_uploaded_file($_FILES['attachment']['tmp_name'], $_SERVER['DOCUMENT_ROOT']."/assets/accounts/".$attachment);
                $slide_img_with_url = base_url()."assets/accounts/".$attachment;
            }else{
                $attachment=$_POST['attachment_old'];
            }
            
            
            
            $acedemic_session_table='academic_session_details';
            $get_session_info=$this->AccountsModel->get_item_data($acedemic_session,$acedemic_session_table);
            if($get_session_info){
                foreach($get_session_info as $ac_session_info){
                    $acedemic_year=$ac_session_info['year_long'];
                }
            }
            $cat=date('Y-m-d H:i:s');
            $userid=$this->session->userdata('tid');
            $day=date('d',strtotime($date));
            $month=date('m',strtotime($date));
            $year=date('Y',strtotime($date));
            $table='accounts_ledger';
            // particulars debit credit balance uat upd_by 
            $data_array=array("particulars_id"=>$particulars,"particulars"=>$particular_type,"type"=>$account_head_type,"amount"=>$amount,"acedemic_session"=>$acedemic_session,"acedemic_year"=>$acedemic_year,"date"=>$date,"day"=>$day,"month"=>$month,"year"=>$year,"cat"=>$cat,"cat_by"=>$userid,"description"=>$description,"attachment"=>$attachment);
            
            
            $data_array_update=array("particulars_id"=>$particulars,"particulars"=>$particular_type,"type"=>$account_head_type,"amount"=>$amount,"acedemic_session"=>$acedemic_session,"acedemic_year"=>$acedemic_year,"date"=>$date,"day"=>$day,"month"=>$month,"year"=>$year,"uat"=>$cat,"upd_by"=>$userid,"description"=>$description,"attachment"=>$attachment);
            $check_record_data=$this->AccountsModel->get_item_data($record_id,$table);
            if($check_record_data){
                $update_record_data=$this->AccountsModel->update_item_data($record_id,$data_array_update,$table);
                if($update_record_data){
                    $data['success']='Updated Successfully';
                }else{
                    $data['error']='Error in updating new record';
                }
            }else{
                $add_new_record=$this->AccountsModel->insert_data($data_array,$table);
                if($add_new_record){
                    $data['success']='Added Successfully !';
                }else{
                    $data['error']='Error in adding new record !';
                }
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/accounts/add-new-record',$data);
        $this->load->view('erp/footer');
    }
    
    public function view_month_ledger(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/accounts/view-month-ledger');
        $this->load->view('erp/footer');
    }
    
}